/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.mixins;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(library={"zone-refresh.js"})
public class ZoneRefresh {
    @Parameter(required=true, defaultPrefix="literal")
    private int period;
    @Parameter
    private Object[] context;
    @InjectContainer
    private Zone zone;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ComponentResources resources;

    public ZoneRefresh() {
    }

    ZoneRefresh(Object[] context, ComponentResources resources, JavaScriptSupport javaScriptSupport, Zone zone) {
        this.context = context;
        this.resources = resources;
        this.javaScriptSupport = javaScriptSupport;
        this.zone = zone;
    }

    @AfterRender
    void addJavaScript() {
        JSONObject params = new JSONObject();
        params.put("period", (Object)this.period);
        params.put("id", (Object)this.zone.getClientId());
        params.put("URL", this.createEventLink());
        this.javaScriptSupport.addInitializerCall(InitializationPriority.LATE, "zoneRefresh", params);
    }

    private Object createEventLink() {
        Link link = this.resources.createEventLink("zoneRefresh", this.context);
        return link.toAbsoluteURI();
    }

    Object onZoneRefresh(EventContext eventContext) {
        CaptureResultCallback callback = new CaptureResultCallback();
        this.resources.triggerContextEvent("refresh", eventContext, callback);
        if (callback.getResult() != null) {
            return callback.getResult();
        }
        return this.zone.getBody();
    }
}

