/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.mixins;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.MarkupWriterFactory;
import org.apache.tapestry5.services.ResponseRenderer;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.TextStreamResponse;

@Import(library={"${tapestry.scriptaculous}/controls.js", "autocomplete.js"})
public class Autocomplete {
    static final String EVENT_NAME = "autocomplete";
    private static final String PARAM_NAME = "t:input";
    @InjectContainer
    private Field field;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport jsSupport;
    @Inject
    private TypeCoercer coercer;
    @Inject
    private MarkupWriterFactory factory;
    @Inject
    @Path(value="${tapestry.spacer-image}")
    private Asset spacerImage;
    @Parameter(defaultPrefix="literal")
    private int minChars;
    @Inject
    private ResponseRenderer responseRenderer;
    @Parameter(defaultPrefix="literal")
    private double frequency;
    @Parameter(defaultPrefix="literal")
    private String tokens;

    void afterRender(MarkupWriter writer) {
        String id = this.field.getClientId();
        String menuId = id + ":menu";
        String loaderId = id + ":loader";
        writer.element("img", "src", this.spacerImage.toClientURL(), "class", "t-autoloader-icon t-invisible", "alt", "", "id", loaderId);
        writer.end();
        writer.element("div", "id", menuId, "class", "t-autocomplete-menu");
        writer.end();
        Link link = this.resources.createEventLink(EVENT_NAME, new Object[0]);
        JSONObject config = new JSONObject();
        config.put("paramName", (Object)PARAM_NAME);
        config.put("indicator", (Object)loaderId);
        if (this.resources.isBound("minChars")) {
            config.put("minChars", (Object)this.minChars);
        }
        if (this.resources.isBound("frequency")) {
            config.put("frequency", (Object)this.frequency);
        }
        if (this.resources.isBound("tokens")) {
            for (int i = 0; i < this.tokens.length(); ++i) {
                config.accumulate("tokens", (Object)this.tokens.substring(i, i + 1));
            }
        }
        this.configure(config);
        JSONObject spec = new JSONObject(new String[]{"elementId", id, "menuId", menuId, "url", link.toURI()}).put("config", (Object)config);
        this.jsSupport.addInitializerCall("autocompleter", spec);
    }

    Object onAutocomplete(@RequestParameter(value="t:input") String input) {
        final Holder matchesHolder = Holder.create();
        matchesHolder.put(Collections.emptyList());
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                List matches = (List)Autocomplete.this.coercer.coerce(result, List.class);
                matchesHolder.put(matches);
                return true;
            }
        };
        this.resources.triggerEvent("provideCompletions", new Object[]{input}, callback);
        ContentType contentType = this.responseRenderer.findContentType(this);
        MarkupWriter writer = this.factory.newPartialMarkupWriter(contentType);
        this.generateResponseMarkup(writer, (List)matchesHolder.get());
        return new TextStreamResponse(contentType.toString(), writer.toString());
    }

    protected void configure(JSONObject config) {
    }

    protected void generateResponseMarkup(MarkupWriter writer, List matches) {
        writer.element("ul", new Object[0]);
        for (Object o : matches) {
            writer.element("li", new Object[0]);
            writer.write(o.toString());
            writer.end();
        }
        writer.end();
    }
}

