/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.tree.DefaultTreeExpansionModel;
import org.apache.tapestry5.tree.TreeExpansionModel;
import org.apache.tapestry5.tree.TreeModel;
import org.apache.tapestry5.tree.TreeNode;
import org.apache.tapestry5.tree.TreeSelectionModel;

public class Tree {
    @Parameter(required=true, autoconnect=true)
    private TreeModel model;
    @Parameter(name="class", defaultPrefix="literal")
    private String className;
    @Property
    @Parameter
    private TreeNode node;
    @Parameter(allowNull=false, value="defaultTreeExpansionModel")
    private TreeExpansionModel expansionModel;
    @Parameter
    private TreeSelectionModel selectionModel;
    @Parameter
    private Object value;
    @Property
    @Parameter(value="block:defaultRenderTreeNodeLabel")
    private RenderCommand label;
    @Environmental
    private JavaScriptSupport jss;
    @Inject
    private ComponentResources resources;
    @Persist
    private TreeExpansionModel defaultTreeExpansionModel;
    private static RenderCommand RENDER_CLOSE_TAG = new RenderCommand(){

        public void render(MarkupWriter writer, RenderQueue queue) {
            writer.end();
        }
    };
    private static RenderCommand RENDER_LABEL_SPAN = new RenderCommand(){

        public void render(MarkupWriter writer, RenderQueue queue) {
            writer.element("span", "class", "t-tree-label");
        }
    };

    private RenderCommand toRenderCommand(final TreeNode node, final boolean isLast) {
        return new RenderCommand(){

            public void render(MarkupWriter writer, RenderQueue queue) {
                Tree.this.node = node;
                Tree.this.value = node.getValue();
                writer.element("li", new Object[0]);
                if (isLast) {
                    writer.attributes("class", "t-last");
                }
                Element e = writer.element("span", "class", "t-tree-icon");
                if (node.isLeaf()) {
                    e.addClassName("t-leaf-node");
                } else if (!node.getHasChildren()) {
                    e.addClassName("t-empty-node");
                }
                boolean hasChildren = !node.isLeaf() && node.getHasChildren();
                boolean expanded = hasChildren && Tree.this.expansionModel.isExpanded(node);
                String clientId = Tree.this.jss.allocateClientId(Tree.this.resources);
                JSONObject spec = new JSONObject(new String[]{"clientId", clientId});
                e.attribute("id", clientId);
                spec.put("leaf", (Object)node.isLeaf());
                if (hasChildren) {
                    Link expandChildren = Tree.this.resources.createEventLink("expandChildren", node.getId());
                    Link markExpanded = Tree.this.resources.createEventLink("markExpanded", node.getId());
                    Link markCollapsed = Tree.this.resources.createEventLink("markCollapsed", node.getId());
                    spec.put("expandChildrenURL", (Object)expandChildren.toString()).put("markExpandedURL", (Object)markExpanded.toString()).put("markCollapsedURL", (Object)markCollapsed.toString());
                    if (expanded) {
                        spec.put("expanded", (Object)true);
                    }
                } else if (Tree.this.selectionModel != null) {
                    Link selectLeaf = Tree.this.resources.createEventLink("select", node.getId());
                    spec.put("selectURL", (Object)selectLeaf.toString());
                    if (Tree.this.selectionModel.isSelected(node)) {
                        spec.put("selected", (Object)true);
                    }
                }
                Tree.this.jss.addInitializerCall("treeNode", spec);
                writer.end();
                queue.push(RENDER_CLOSE_TAG);
                if (expanded) {
                    queue.push(new RenderNodes(node.getChildren()));
                }
                queue.push(RENDER_CLOSE_TAG);
                queue.push(Tree.this.label);
                queue.push(RENDER_LABEL_SPAN);
            }
        };
    }

    public String getContainerClass() {
        return this.className == null ? "t-tree-container" : "t-tree-container " + this.className;
    }

    Object onExpandChildren(String nodeId) {
        TreeNode container = this.model.getById(nodeId);
        this.expansionModel.markExpanded(container);
        return new RenderNodes(container.getChildren());
    }

    Object onMarkExpanded(String nodeId) {
        this.expansionModel.markExpanded(this.model.getById(nodeId));
        return new JSONObject();
    }

    Object onMarkCollapsed(String nodeId) {
        this.expansionModel.markCollapsed(this.model.getById(nodeId));
        return new JSONObject();
    }

    Object onSelect(String nodeId, @RequestParameter(value="t:selected") boolean selected) {
        String event;
        TreeNode node = this.model.getById(nodeId);
        if (selected) {
            this.selectionModel.select(node);
            event = "nodeSelected";
        } else {
            this.selectionModel.unselect(node);
            event = "nodeUnselected";
        }
        CaptureResultCallback callback = CaptureResultCallback.create();
        this.resources.triggerEvent(event, new Object[]{nodeId}, callback);
        Object result = callback.getResult();
        if (result != null) {
            return result;
        }
        return new JSONObject();
    }

    public TreeExpansionModel getDefaultTreeExpansionModel() {
        if (this.defaultTreeExpansionModel == null) {
            this.defaultTreeExpansionModel = new DefaultTreeExpansionModel();
        }
        return this.defaultTreeExpansionModel;
    }

    public TreeExpansionModel getExpansionModel() {
        return this.expansionModel;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Object getRenderRootNodes() {
        return new RenderNodes(this.model.getRootNodes());
    }

    public void clearExpansions() {
        this.expansionModel.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RenderNodes
    implements RenderCommand {
        private final Flow<TreeNode> nodes;

        public RenderNodes(List<TreeNode> nodes) {
            assert (!nodes.isEmpty());
            this.nodes = (Flow)F.flow(nodes).reverse();
        }

        @Override
        public void render(MarkupWriter writer, final RenderQueue queue) {
            writer.element("ul", new Object[0]);
            queue.push(RENDER_CLOSE_TAG);
            queue.push(Tree.this.toRenderCommand((TreeNode)this.nodes.first(), true));
            ((Flow)this.nodes.rest()).each((Worker)new Worker<TreeNode>(){

                public void work(TreeNode element) {
                    queue.push(Tree.this.toRenderCommand(element, false));
                }
            });
        }
    }
}

