/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.SubmitMode;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class LinkSubmit
implements ClientElement {
    @Parameter
    private boolean disabled;
    @Parameter(allowNull=false, defaultPrefix="literal")
    private String event = "selected";
    @Parameter(allowNull=false, defaultPrefix="literal")
    private SubmitMode mode = SubmitMode.NORMAL;
    @Parameter
    private boolean defer = true;
    @Parameter
    private Object[] context;
    @Inject
    private ComponentResources resources;
    @Inject
    private JavaScriptSupport javascriptSupport;
    @Environmental
    private FormSupport formSupport;
    @Environmental
    private Heartbeat heartbeat;
    @Inject
    private Request request;
    @Environmental
    private TrackableComponentEventCallback eventCallback;
    private String clientId;

    private void processSubmission(String clientId) {
        this.clientId = clientId;
        String raw = this.request.getParameter("t:submit");
        if (InternalUtils.isNonBlank((String)raw) && new JSONArray(raw).getString(0).equals(clientId)) {
            Runnable notification = new Runnable(){

                public void run() {
                    LinkSubmit.this.resources.triggerEvent(LinkSubmit.this.event, LinkSubmit.this.context, LinkSubmit.this.eventCallback);
                }
            };
            if (this.defer) {
                this.formSupport.defer(notification);
            } else {
                this.heartbeat.defer(notification);
            }
        }
    }

    void beginRender(MarkupWriter writer) {
        if (!this.disabled) {
            this.clientId = this.javascriptSupport.allocateClientId(this.resources);
            this.formSupport.store(this, new ProcessSubmission(this.clientId));
            writer.element("span", "id", this.clientId);
            this.resources.renderInformalParameters(writer);
        }
    }

    void afterRender(MarkupWriter writer) {
        if (!this.disabled) {
            writer.end();
            JSONObject spec = new JSONObject(new String[]{"form", this.formSupport.getClientId(), "clientId", this.clientId});
            spec.put("mode", (Object)this.mode.name().toLowerCase());
            this.javascriptSupport.addInitializerCall(InitializationPriority.EARLY, "linkSubmit", spec);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessSubmission
    implements ComponentAction<LinkSubmit> {
        private final String clientId;

        public ProcessSubmission(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public void execute(LinkSubmit component) {
            component.processSubmission(this.clientId);
        }
    }
}

