/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class GridPager {
    @Parameter(required=true)
    private GridDataSource source;
    @Parameter(required=true)
    private int rowsPerPage;
    @Parameter(required=true)
    private int currentPage;
    @Parameter(value="symbol:tapestry.components.gridpager_page_range")
    private int range;
    @Parameter
    private String zone;
    private int lastIndex;
    private int maxPages;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Environmental
    private ClientBehaviorSupport clientBehaviorSupport;
    @Environmental
    private JavaScriptSupport jsSupport;

    void beginRender(MarkupWriter writer) {
        int i;
        int availableRows = this.source.getAvailableRows();
        this.maxPages = (availableRows - 1) / this.rowsPerPage + 1;
        if (this.maxPages < 2) {
            return;
        }
        writer.element("div", "class", "t-data-grid-pager");
        this.lastIndex = 0;
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.writePageLink(writer, i2);
        }
        int low = this.currentPage - this.range;
        int high = this.currentPage + this.range;
        if (low < 1) {
            low = 1;
            high = 2 * this.range + 1;
        } else if (high > this.maxPages) {
            high = this.maxPages;
            low = high - 2 * this.range;
        }
        for (i = low; i <= high; ++i) {
            this.writePageLink(writer, i);
        }
        for (i = this.maxPages - 1; i <= this.maxPages; ++i) {
            this.writePageLink(writer, i);
        }
        writer.end();
    }

    private void writePageLink(MarkupWriter writer, int pageIndex) {
        Object[] objectArray;
        if (pageIndex < 1 || pageIndex > this.maxPages) {
            return;
        }
        if (pageIndex <= this.lastIndex) {
            return;
        }
        if (pageIndex != this.lastIndex + 1) {
            writer.write(" ... ");
        }
        this.lastIndex = pageIndex;
        if (pageIndex == this.currentPage) {
            writer.element("span", "class", "current");
            writer.write(Integer.toString(pageIndex));
            writer.end();
            return;
        }
        if (this.zone == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = pageIndex;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = pageIndex;
            objectArray = objectArray3;
            objectArray3[1] = this.zone;
        }
        Object[] context = objectArray;
        Link link = this.resources.createEventLink("action", context);
        Element element = writer.element("a", "href", this.zone == null ? link : "#", "title", this.messages.format("goto-page", new Object[]{pageIndex}));
        writer.write(Integer.toString(pageIndex));
        writer.end();
        if (this.zone != null) {
            String id = this.jsSupport.allocateClientId(this.resources);
            element.attribute("id", id);
            this.clientBehaviorSupport.linkZone(id, this.zone, link);
        }
    }

    void onAction(int newPage) {
        this.currentPage = newPage;
    }

    boolean onAction(int newPage, String zone) {
        this.onAction(newPage);
        this.resources.triggerEvent("inplaceupdate", new Object[]{zone}, null);
        return true;
    }
}

