/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.corelib.components.EventLink;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridModel;
import org.apache.tapestry5.grid.GridSortModel;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportsInformalParameters
public class GridColumns {
    @Parameter(value="componentResources.container")
    private GridModel gridModel;
    @Parameter
    private boolean lean;
    @Parameter(value="this")
    private PropertyOverrides overrides;
    @Parameter
    private String zone;
    @Component(parameters={"event=sort", "disabled=sortDisabled", "context=columnContext", "class=sortLinkClass", "zone=inherit:zone"})
    private EventLink sort;
    @Component(parameters={"event=sort", "disabled=sortDisabled", "context=columnContext", "class=sortLinkClass", "zone=inherit:zone"})
    private EventLink sort2;
    @Inject
    @Path(value="${tapestry.components.gridcolumns_ascending_asset}")
    private Asset ascendingAsset;
    @Inject
    @Path(value="${tapestry.components.gridcolumns_descending_asset}")
    private Asset descendingAsset;
    @Inject
    @Path(value="${tapestry.components.gridcolumns_sortable_asset}")
    private Asset sortableAsset;
    @Inject
    private Messages messages;
    @Inject
    private Block standardHeader;
    @Parameter
    @Property
    private int index;
    private int lastColumnIndex;
    @Property(write=false)
    private PropertyModel columnModel;
    @Inject
    private ComponentResources resources;

    void setupRender() {
        this.lastColumnIndex = this.gridModel.getDataModel().getPropertyNames().size() - 1;
    }

    public boolean isSortDisabled() {
        return !this.columnModel.isSortable();
    }

    public String getSortLinkClass() {
        switch (this.getSortForColumn()) {
            case ASCENDING: {
                return "t-sort-column-ascending";
            }
            case DESCENDING: {
                return "t-sort-column-descending";
            }
        }
        return null;
    }

    private ColumnSort getSortForColumn() {
        GridSortModel sortModel = this.gridModel.getSortModel();
        String columnId = this.columnModel.getId();
        return sortModel.getColumnSort(columnId);
    }

    public String getHeaderClass() {
        String sort;
        List classes = CollectionFactory.newList();
        if (!this.lean) {
            classes.add(this.columnModel.getId());
        }
        if ((sort = this.getSortLinkClass()) != null) {
            classes.add(sort);
        }
        if (this.index == 0) {
            classes.add("t-first");
        }
        if (this.index == this.lastColumnIndex) {
            classes.add("t-last");
        }
        return TapestryInternalUtils.toClassAttributeValue(classes);
    }

    public boolean isActiveSortColumn() {
        return this.getSortForColumn() != ColumnSort.UNSORTED;
    }

    void onSort(String columnId) {
        this.gridModel.getSortModel().updateSort(columnId);
    }

    boolean onSort(String columnId, String zone) {
        this.onSort(columnId);
        this.resources.triggerEvent("inplaceupdate", new Object[]{zone}, null);
        return true;
    }

    public Asset getIcon() {
        switch (this.getSortForColumn()) {
            case ASCENDING: {
                return this.ascendingAsset;
            }
            case DESCENDING: {
                return this.descendingAsset;
            }
        }
        return this.sortableAsset;
    }

    public Object getColumnContext() {
        if (this.zone == null) {
            return this.columnModel.getId();
        }
        return new Object[]{this.columnModel.getId(), this.zone};
    }

    public String getIconLabel() {
        switch (this.getSortForColumn()) {
            case ASCENDING: {
                return this.messages.get("ascending");
            }
            case DESCENDING: {
                return this.messages.get("descending");
            }
        }
        return this.messages.get("sortable");
    }

    public List<String> getColumnNames() {
        return this.gridModel.getDataModel().getPropertyNames();
    }

    public void setColumnName(String columnName) {
        this.columnModel = this.gridModel.getDataModel().get(columnName);
    }

    public Block getBlockForColumn() {
        Block override = this.overrides.getOverrideBlock(this.columnModel.getId() + "Header");
        if (override != null) {
            return override;
        }
        return this.standardHeader;
    }
}

