/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.services.ExceptionAnalysis;
import org.apache.tapestry5.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry5.ioc.services.ExceptionInfo;
import org.apache.tapestry5.services.StackTraceElementAnalyzer;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(library={"exceptiondisplay.js"})
public class ExceptionDisplay {
    @Parameter(required=true, allowNull=false)
    private Throwable exception;
    @Inject
    private ExceptionAnalyzer analyzer;
    @Property
    private ExceptionInfo info;
    @Property
    private String propertyName;
    @Property
    private StackTraceElement frame;
    @Property
    private List<ExceptionInfo> stack;
    @Environmental
    private JavaScriptSupport jsSupport;
    @Property
    private String toggleId;
    private boolean sawDoFilter;
    @Inject
    @Primary
    private StackTraceElementAnalyzer frameAnalyzer;

    void setupRender() {
        ExceptionAnalysis analysis = this.analyzer.analyze(this.exception);
        this.stack = analysis.getExceptionInfos();
        this.toggleId = this.jsSupport.allocateClientId("toggleStack");
    }

    public boolean getShowPropertyList() {
        return !this.info.getPropertyNames().isEmpty() || !this.info.getStackTrace().isEmpty();
    }

    public Object getPropertyValue() {
        return this.info.getProperty(this.propertyName);
    }

    public String getFrameClass() {
        if (this.sawDoFilter) {
            return "t-omitted-frame";
        }
        String result = this.frameAnalyzer.classForFrame(this.frame);
        this.sawDoFilter |= this.frame.getMethodName().equals("doFilter");
        return result;
    }

    void afterRender() {
        this.jsSupport.addScript("Tapestry.stackFrameToggle('%s');", this.toggleId);
    }
}

