/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.alerts;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.OptimizedSessionPersistedObject;
import org.apache.tapestry5.alerts.Alert;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertStorage
extends LockSupport
implements Serializable,
OptimizedSessionPersistedObject {
    private boolean dirty;
    private final List<Alert> alerts = CollectionFactory.newList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAndResetDirtyMarker() {
        try {
            this.takeWriteLock();
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Alert alert) {
        assert (alert != null);
        try {
            this.takeWriteLock();
            this.alerts.add(alert);
            this.dirty = true;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissAll() {
        try {
            this.takeWriteLock();
            if (!this.alerts.isEmpty()) {
                this.alerts.clear();
                this.dirty = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissNonPersistent() {
        try {
            this.takeWriteLock();
            Iterator<Alert> i = this.alerts.iterator();
            while (i.hasNext()) {
                if (i.next().duration.persistent) continue;
                this.dirty = true;
                i.remove();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss(long alertId) {
        try {
            this.takeWriteLock();
            Iterator<Alert> i = this.alerts.iterator();
            while (i.hasNext()) {
                if (i.next().id != alertId) continue;
                i.remove();
                this.dirty = true;
                return;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Alert> getAlerts() {
        try {
            this.acquireReadLock();
            List<Alert> list = this.alerts;
            return list;
        }
        finally {
            this.releaseReadLock();
        }
    }
}

