/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.security.ProtectionDomain;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.tapestry5.ioc.internal.services.ClassFactoryClassPool;
import org.apache.tapestry5.ioc.internal.services.CtClassSource;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.services.ClassFabUtils;

public class CtClassSourceImpl
implements CtClassSource {
    private static final String WRITE_DIR = System.getProperty("javassist-write-dir");
    private final ClassFactoryClassPool pool;
    private final ClassLoader loader;
    private final ProtectionDomain domain = this.getClass().getProtectionDomain();
    private int createdClassCount = 0;

    public synchronized int getCreatedClassCount() {
        return this.createdClassCount;
    }

    public CtClassSourceImpl(ClassFactoryClassPool pool, ClassLoader loader) {
        this.pool = pool;
        this.loader = loader;
    }

    public synchronized CtClass toCtClass(Class searchClass) {
        ClassLoader loader = searchClass.getClassLoader();
        this.pool.addClassLoaderIfNeeded(loader);
        String name = ClassFabUtils.toJavaClassName(searchClass);
        return this.toCtClass(name);
    }

    public CtClass toCtClass(String name) {
        try {
            return this.pool.get(name);
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ServiceMessages.unableToLookupClass(name, ex), ex);
        }
    }

    public CtClass newClass(String name, Class superClass) {
        CtClass ctSuperClass = this.toCtClass(superClass);
        return this.pool.makeClass(name, ctSuperClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class createClass(CtClass ctClass) {
        if (WRITE_DIR != null) {
            this.writeClass(ctClass);
        }
        try {
            Class result = this.pool.toClass(ctClass, this.loader, this.domain);
            CtClassSourceImpl ctClassSourceImpl = this;
            synchronized (ctClassSourceImpl) {
                ++this.createdClassCount;
            }
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ServiceMessages.unableToWriteClass(ctClass, ex), ex);
        }
    }

    private void writeClass(CtClass ctClass) {
        try {
            ctClass.debugWriteFile(WRITE_DIR);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

