/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.annotations.SubModule;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.internal.DefaultModuleDefImpl;
import org.apache.tapestry5.ioc.internal.LoggerSourceImpl;
import org.apache.tapestry5.ioc.internal.RegistryImpl;
import org.apache.tapestry5.ioc.internal.RegistryWrapper;
import org.apache.tapestry5.ioc.internal.services.ClassFactoryImpl;
import org.apache.tapestry5.ioc.internal.services.PlasticProxyFactoryImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.TapestryIOCModule;
import org.slf4j.Logger;

public final class RegistryBuilder {
    private final OneShotLock lock = new OneShotLock();
    final List<ModuleDef> modules = CollectionFactory.newList();
    private final ClassLoader classLoader;
    private final Logger logger;
    private final LoggerSource loggerSource;
    private final ClassFactory classFactory;
    private final PlasticProxyFactory proxyFactory;
    private final Set<Class> addedModuleClasses = CollectionFactory.newSet();

    public RegistryBuilder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public RegistryBuilder(ClassLoader classLoader) {
        this(classLoader, new LoggerSourceImpl());
    }

    public RegistryBuilder(ClassLoader classLoader, LoggerSource loggerSource) {
        this.classLoader = classLoader;
        this.loggerSource = loggerSource;
        this.logger = loggerSource.getLogger(RegistryBuilder.class);
        Logger classFactoryLogger = loggerSource.getLogger(TapestryIOCModule.class.getName() + ".ClassFactory");
        Logger proxyFactoryLogger = loggerSource.getLogger(TapestryIOCModule.class.getName() + ".PlasticProxyFactory");
        this.classFactory = new ClassFactoryImpl(this.classLoader, classFactoryLogger);
        this.proxyFactory = new PlasticProxyFactoryImpl(this.classLoader, proxyFactoryLogger);
        this.add(TapestryIOCModule.class);
    }

    public RegistryBuilder add(ModuleDef moduleDef) {
        this.lock.check();
        this.modules.add(moduleDef);
        return this;
    }

    public RegistryBuilder add(Class ... moduleClasses) {
        this.lock.check();
        List queue = CollectionFactory.newList(Arrays.asList(moduleClasses));
        while (!queue.isEmpty()) {
            Class c = (Class)queue.remove(0);
            if (this.addedModuleClasses.contains(c)) continue;
            this.addedModuleClasses.add(c);
            this.logger.info("Adding module definition for " + c);
            DefaultModuleDefImpl def = new DefaultModuleDefImpl(c, this.logger, this.proxyFactory);
            this.add(def);
            SubModule annotation = c.getAnnotation(SubModule.class);
            if (annotation == null) continue;
            queue.addAll(Arrays.asList(annotation.value()));
        }
        return this;
    }

    public RegistryBuilder add(String classname) {
        this.lock.check();
        try {
            Class<?> builderClass = Class.forName(classname, true, this.classLoader);
            this.add(builderClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failure loading Tapestry IoC module class %s: %s", classname, InternalUtils.toMessage(ex), ex));
        }
        return this;
    }

    public Registry build() {
        this.lock.lock();
        RegistryImpl registry = new RegistryImpl(this.modules, this.classFactory, this.proxyFactory, this.loggerSource);
        return new RegistryWrapper(registry);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static Registry buildAndStartupRegistry(ModuleDef moduleDef, Class ... moduleClasses) {
        RegistryBuilder builder = new RegistryBuilder();
        if (moduleDef != null) {
            builder.add(moduleDef);
        }
        builder.add(moduleClasses);
        Registry registry = builder.build();
        registry.performRegistryStartup();
        return registry;
    }

    public static Registry buildAndStartupRegistry(Class ... moduleClasses) {
        return RegistryBuilder.buildAndStartupRegistry(null, moduleClasses);
    }
}

