/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;

public class ParameterDescription {
    public final FieldDoc field;
    public final String name;
    public final String type;
    public final String defaultValue;
    public final String defaultPrefix;
    public final boolean required;
    public final boolean allowNull;
    public final boolean cache;
    public final String since;
    public final boolean deprecated;
    private static final Pattern STRIPPER = Pattern.compile("(<.*?>|&.*?;)", 32);

    public ParameterDescription(FieldDoc fieldDoc, String name, String type, String defaultValue, String defaultPrefix, boolean required, boolean allowNull, boolean cache, String since, boolean deprecated) {
        this.field = fieldDoc;
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.defaultPrefix = defaultPrefix;
        this.required = required;
        this.allowNull = allowNull;
        this.cache = cache;
        this.since = since;
        this.deprecated = deprecated;
    }

    public void writeDescription(Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : this.field.inlineTags()) {
            if (tag.name().equals("Text")) {
                builder.append(tag.text());
                continue;
            }
            if (!tag.name().equals("@link")) continue;
            SeeTag seeTag = (SeeTag)tag;
            String label = seeTag.label();
            if (label != null && !label.equals("")) {
                builder.append(label);
                continue;
            }
            if (seeTag.referencedClassName() != null) {
                builder.append(seeTag.referencedClassName());
            }
            if (seeTag.referencedMemberName() == null) continue;
            builder.append("#");
            builder.append(seeTag.referencedMemberName());
        }
        String text = builder.toString();
        String stripped = STRIPPER.matcher(text).replaceAll("");
        writer.write(stripped);
    }
}

