/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.io.Serializable;
import org.apache.tapestry5.internal.hibernate.HibernateMessages;
import org.apache.tapestry5.internal.hibernate.PersistedEntity;
import org.apache.tapestry5.internal.services.AbstractSessionPersistentFieldStrategy;
import org.apache.tapestry5.services.Request;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class EntityPersistentFieldStrategy
extends AbstractSessionPersistentFieldStrategy {
    private final Session session;

    public EntityPersistentFieldStrategy(Session session, Request request) {
        super("entity:", request);
        this.session = session;
    }

    protected Object convertApplicationValueToPersisted(Object newValue) {
        try {
            String entityName = this.session.getEntityName(newValue);
            Serializable id = this.session.getIdentifier(newValue);
            return new PersistedEntity(entityName, id);
        }
        catch (HibernateException ex) {
            throw new IllegalArgumentException(HibernateMessages.entityNotAttached(newValue), ex);
        }
    }

    protected Object convertPersistedToApplicationValue(Object persistedValue) {
        PersistedEntity persisted = (PersistedEntity)persistedValue;
        return persisted.restore(this.session);
    }
}

