/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.hibernate;

import java.util.Iterator;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.hibernate.HibernateCore;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.internal.hibernate.CommitAfterWorker;
import org.apache.tapestry5.internal.hibernate.EntityApplicationStatePersistenceStrategy;
import org.apache.tapestry5.internal.hibernate.EntityPersistentFieldStrategy;
import org.apache.tapestry5.internal.hibernate.HibernateEntityValueEncoder;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.ServiceOverride;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.ApplicationStateContribution;
import org.apache.tapestry5.services.ApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.PersistentFieldStrategy;
import org.apache.tapestry5.services.ValueEncoderFactory;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.hibernate.Session;
import org.hibernate.mapping.PersistentClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateModule {
    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.hibernate.provide-entity-value-encoders", (Object)"true");
        configuration.add((Object)"tapestry.hibernate.entity-session-state-persistence-strategy-enabled", (Object)"false");
    }

    public static void contributeHibernateEntityPackageManager(Configuration<String> configuration, @Symbol(value="tapestry.app-package") String appRootPackage) {
        configuration.add((Object)(appRootPackage + ".entities"));
    }

    @Contribute(value=ServiceOverride.class)
    public static void provideInjectableSessionObject(MappedConfiguration<Class, Object> configuration, @HibernateCore Session session) {
        configuration.add(Session.class, (Object)session);
    }

    public static void contributeValueEncoderSource(MappedConfiguration<Class, ValueEncoderFactory> configuration, @Symbol(value="tapestry.hibernate.provide-entity-value-encoders") boolean provideEncoders, HibernateSessionSource sessionSource, final Session session, final TypeCoercer typeCoercer, final PropertyAccess propertyAccess, final LoggerSource loggerSource) {
        if (!provideEncoders) {
            return;
        }
        org.hibernate.cfg.Configuration config = sessionSource.getConfiguration();
        Iterator mappings = config.getClassMappings();
        while (mappings.hasNext()) {
            final PersistentClass persistentClass = (PersistentClass)mappings.next();
            final Class entityClass = persistentClass.getMappedClass();
            if (entityClass == null) continue;
            ValueEncoderFactory factory = new ValueEncoderFactory(){

                public ValueEncoder create(Class type) {
                    return new HibernateEntityValueEncoder(entityClass, persistentClass, session, propertyAccess, typeCoercer, loggerSource.getLogger(entityClass));
                }
            };
            configuration.add((Object)entityClass, (Object)factory);
        }
    }

    public static void contributePersistentFieldManager(MappedConfiguration<String, PersistentFieldStrategy> configuration) {
        configuration.addInstance((Object)"entity", EntityPersistentFieldStrategy.class);
    }

    public void contributeApplicationStatePersistenceStrategySource(MappedConfiguration<String, ApplicationStatePersistenceStrategy> configuration) {
        configuration.addInstance((Object)"entity", EntityApplicationStatePersistenceStrategy.class);
    }

    public static void contributeApplicationStateManager(MappedConfiguration<Class, ApplicationStateContribution> configuration, @Symbol(value="tapestry.hibernate.entity-session-state-persistence-strategy-enabled") boolean entitySessionStatePersistenceStrategyEnabled, HibernateSessionSource sessionSource) {
        if (!entitySessionStatePersistenceStrategyEnabled) {
            return;
        }
        org.hibernate.cfg.Configuration config = sessionSource.getConfiguration();
        Iterator mappings = config.getClassMappings();
        while (mappings.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)mappings.next();
            Class entityClass = persistentClass.getMappedClass();
            configuration.add((Object)entityClass, (Object)new ApplicationStateContribution("entity"));
        }
    }

    @Contribute(value=ComponentClassTransformWorker2.class)
    @Primary
    public static void provideCommitAfterAnnotationSupport(OrderedConfiguration<ComponentClassTransformWorker2> configuration) {
        configuration.addInstance("CommitAfter", CommitAfterWorker.class, new String[]{"after:Log"});
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("hibernate", "org.apache.tapestry5.hibernate"));
    }
}

