/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.kaptcha.internal.services;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Properties;
import org.apache.tapestry5.kaptcha.services.KaptchaProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KaptchaProducerImpl
implements KaptchaProducer {
    private final DefaultKaptcha producer = new DefaultKaptcha();
    private final int height;
    private final int width;

    public KaptchaProducerImpl(Map<String, String> configuration) {
        Config config = new Config(KaptchaProducerImpl.toProperties(configuration));
        this.producer.setConfig(config);
        this.height = config.getHeight();
        this.width = config.getWidth();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public BufferedImage createImage(String text) {
        return this.producer.createImage(text);
    }

    public String createText() {
        return this.producer.createText();
    }

    private static Properties toProperties(Map<String, String> map) {
        Properties result = new Properties();
        for (String key : map.keySet()) {
            result.put(key, map.get(key));
        }
        return result;
    }
}

