/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sysds.runtime.iogen.MappingTrieNode;
import org.apache.sysds.runtime.matrix.data.Pair;

public class MappingTrie {
    private MappingTrieNode root = new MappingTrieNode(MappingTrieNode.Type.INNER);
    private int keyLevel = 0;
    private boolean inALine = true;
    private int windowSize = 100;

    public void setInALine(boolean inALine) {
        this.inALine = inALine;
    }

    public void insert(String word, int rowIndex) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        tmpList.add(rowIndex);
        this.insert(word, tmpList);
    }

    public void reverseInsert(String word, int rowIndex) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        tmpList.add(rowIndex);
        this.insert(new StringBuilder(word).reverse().toString(), tmpList);
    }

    public void insert(String word, ArrayList<Integer> rowIndexes) {
        MappingTrieNode newNode = this.root.getChildren().containsKey(word) ? this.root.getChildren().get(word) : new MappingTrieNode();
        newNode.addRowIndex(rowIndexes);
        this.root.getChildren().put(word, newNode);
    }

    public MappingTrieNode getFistMultiChildNode(MappingTrieNode node) {
        if (node.getNodeType() == MappingTrieNode.Type.INNER && node.getChildren().size() == 1) {
            String nkey = node.getChildren().keySet().iterator().next();
            if (node.getChildren().get(nkey).getRowIndexes().size() > 1) {
                return node;
            }
        }
        if (node.getChildren().size() == 1 && node.getNodeType() != MappingTrieNode.Type.END) {
            return this.getFistMultiChildNode(node.getChildren().get(node.getChildren().keySet().iterator().next()));
        }
        return node;
    }

    public void insertKeys(ArrayList<String> keys) {
        MappingTrieNode currentNode = this.root;
        int index = 0;
        for (String key : keys) {
            if (!currentNode.getChildren().containsKey(key)) break;
            currentNode = currentNode.getChildren().get(key);
            ++index;
        }
        for (int i = index; i < keys.size(); ++i) {
            MappingTrieNode newNode = new MappingTrieNode();
            currentNode.getChildren().put(keys.get(i), newNode);
            currentNode = newNode;
        }
    }

    public Set<String> getAllSubStringsOfStringContainIntersect(String str, BitSet bitSet) {
        HashSet<String> result = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bitSet.size(); ++i) {
            if (bitSet.get(i)) {
                sb.append(str.charAt(i));
                continue;
            }
            if (sb.length() <= 0) continue;
            this.getAllSubStrings(result, sb);
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            this.getAllSubStrings(result, sb);
        }
        return result;
    }

    private void getAllSubStrings(HashSet<String> result, StringBuilder sb) {
        if (sb.length() == 1) {
            result.add(sb.toString());
        } else {
            for (int j = 1; j <= Math.min(sb.length(), this.windowSize); ++j) {
                for (int k = 0; k <= sb.length() - j; ++k) {
                    result.add(sb.substring(k, k + j));
                }
            }
        }
    }

    public String getIntersectOfChildren(MappingTrieNode node) {
        Object object;
        if (node.getNodeType() == MappingTrieNode.Type.END || node.getChildren().size() == 0) {
            return null;
        }
        Set<String> keys = node.getChildren().keySet();
        if (keys.size() == 1) {
            String[] splitText = keys.iterator().next().split("\u00b0", -1);
            String str = splitText[0];
            if (str.length() == 0 && splitText.length > 1) {
                str = splitText[1];
            }
            return String.valueOf(str.charAt(0));
        }
        HashSet<String> newKeys = new HashSet<String>();
        for (String k : keys) {
            String[] splitText = k.split("\u00b0", -1);
            Object str = splitText[0];
            if (((String)str).length() == 0 && splitText.length > 1) {
                str = splitText[1];
            }
            newKeys.add((String)str);
        }
        keys = newKeys;
        boolean flag = false;
        int maxKeyLength = 0;
        Set intersections = null;
        for (String k : keys) {
            if (flag) {
                intersections.retainAll(k.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toSet()));
            } else {
                intersections = k.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toSet());
                flag = true;
            }
            maxKeyLength = Math.max(maxKeyLength, k.length());
        }
        if (intersections == null || intersections.size() == 0) {
            return null;
        }
        Set<Object> subStringIntersection = new HashSet();
        boolean subStringIntersectionFlag = false;
        for (String k : keys) {
            BitSet bitSets = new BitSet(maxKeyLength);
            int i = 0;
            object = k.toCharArray();
            int n = ((char[])object).length;
            for (int j = 0; j < n; ++j) {
                Character character = Character.valueOf(object[j]);
                if (intersections.contains(character)) {
                    bitSets.set(i);
                }
                ++i;
            }
            if (subStringIntersectionFlag) {
                subStringIntersection.retainAll(this.getAllSubStringsOfStringContainIntersect(k, bitSets));
                continue;
            }
            subStringIntersection = this.getAllSubStringsOfStringContainIntersect(k, bitSets);
            subStringIntersectionFlag = true;
        }
        if (subStringIntersection.size() == 1) {
            return (String)subStringIntersection.iterator().next();
        }
        ArrayList sortedList = (ArrayList)subStringIntersection.stream().sorted((o1, o2) -> o2.length() - o1.length()).collect(Collectors.toList());
        for (String ssi : sortedList) {
            if (this.keyLevel == 0 && this.inALine) {
                boolean flagBest = true;
                for (String k : keys) {
                    if (k.startsWith(ssi)) continue;
                    flagBest = false;
                    break;
                }
                if (!flagBest) continue;
                return ssi;
            }
            int lastCount = 0;
            object = keys.iterator();
            while (object.hasNext()) {
                int index;
                String k;
                k = (String)object.next();
                int beginPos = 0;
                int count = 0;
                while ((index = k.indexOf(ssi, beginPos)) != -1) {
                    ++count;
                    beginPos = index + ssi.length();
                }
                if (lastCount != 0 && lastCount != count) {
                    lastCount = 0;
                    break;
                }
                if (lastCount != 0) continue;
                lastCount = count;
            }
            if (lastCount == 0) continue;
            return ssi;
        }
        return null;
    }

    public MappingTrieNode getRoot() {
        return this.root;
    }

    public boolean reConstruct() {
        MappingTrieNode node = this.getFistMultiChildNode(this.root);
        String intersect = this.getIntersectOfChildren(node);
        if (intersect == null) {
            node.getChildren().clear();
            node.setNodeType(MappingTrieNode.Type.END);
            return false;
        }
        MappingTrieNode.Type intersectNodeType = MappingTrieNode.Type.INNER;
        MappingTrie intersectTrie = new MappingTrie();
        ArrayList<Integer> intersectRowIndexes = new ArrayList<Integer>();
        for (String k : node.getChildren().keySet()) {
            String key = k.substring(k.indexOf(intersect) + intersect.length());
            if (key.length() > 0 && !key.equals("\u00b0")) {
                intersectTrie.insert(key, node.getChildren().get(k).getRowIndexes());
                intersectRowIndexes.addAll(node.getChildren().get(k).getRowIndexes());
                continue;
            }
            intersectNodeType = MappingTrieNode.Type.END;
        }
        node.getChildren().clear();
        MappingTrieNode ignoreNode = new MappingTrieNode(MappingTrieNode.Type.IGNORE);
        node.getChildren().put(null, ignoreNode);
        MappingTrieNode intersectionNode = new MappingTrieNode(intersectNodeType);
        intersectionNode.setChildren(intersectTrie.root.getChildren());
        intersectionNode.setRowIndexes(intersectRowIndexes);
        ignoreNode.getChildren().put(intersect, intersectionNode);
        ++this.keyLevel;
        return true;
    }

    public ArrayList<ArrayList<String>> getAllSequentialKeys() {
        ArrayList<ArrayList<Pair<String, ArrayList<Integer>>>> result = new ArrayList<ArrayList<Pair<String, ArrayList<Integer>>>>();
        this.getAllSequentialKeys(this.root, result, new ArrayList<Pair<String, ArrayList<Integer>>>());
        ArrayList<Pair<Integer, Integer>> indexOrder = new ArrayList<Pair<Integer, Integer>>();
        int index = 0;
        for (ArrayList<Pair<String, ArrayList<Integer>>> k : result) {
            int level = 0;
            for (Pair<String, ArrayList<Integer>> n : k) {
                if (n.getKey() == null) continue;
                if (level == this.keyLevel - 1 || this.keyLevel == 0) {
                    indexOrder.add(new Pair<Integer, Integer>(index, n.getValue().size()));
                    break;
                }
                ++level;
            }
            ++index;
        }
        List sortedList = indexOrder.stream().sorted((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue())).collect(Collectors.toList());
        ArrayList keys = new ArrayList();
        for (Pair p : sortedList) {
            ArrayList<Pair<String, ArrayList<Integer>>> k = result.get((Integer)p.getKey());
            ArrayList<String> kl = new ArrayList<String>();
            int n = 0;
            for (Pair<String, ArrayList<Integer>> n2 : k) {
                if (n2.getKey() == null) continue;
                if (n >= this.keyLevel && this.keyLevel != 0) break;
                String[] splitText = n2.getKey().split("\u00b0", -1);
                String str = splitText[0];
                if (str.length() == 0 && splitText.length > 1) {
                    str = splitText[1];
                }
                kl.add(str);
                ++n;
            }
            keys.add(kl);
        }
        ArrayList<ArrayList<String>> distinctKeys = new ArrayList<ArrayList<String>>();
        HashSet<Integer> markedIndexes = new HashSet<Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            if (markedIndexes.contains(i)) continue;
            ArrayList selected = (ArrayList)keys.get(i);
            markedIndexes.add(i);
            distinctKeys.add(selected);
            for (int j = i + 1; j < keys.size(); ++j) {
                if (markedIndexes.contains(j)) continue;
                boolean flag = true;
                for (int k = 0; k < selected.size(); ++k) {
                    if (((String)selected.get(k)).equals(((ArrayList)keys.get(j)).get(k))) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                markedIndexes.add(j);
            }
        }
        for (ArrayList arrayList : distinctKeys) {
            Collections.reverse(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.set(i, new StringBuilder((String)arrayList.get(i)).reverse().toString());
            }
        }
        return distinctKeys;
    }

    private void getAllSequentialKeys(MappingTrieNode node, ArrayList<ArrayList<Pair<String, ArrayList<Integer>>>> result, ArrayList<Pair<String, ArrayList<Integer>>> nodeKeys) {
        if (node.getNodeType() == MappingTrieNode.Type.END) {
            result.add(nodeKeys);
            nodeKeys = new ArrayList();
        } else {
            for (String k : node.getChildren().keySet()) {
                MappingTrieNode child = node.getChildren().get(k);
                ArrayList<Pair<String, ArrayList<Integer>>> tmpKeys = new ArrayList<Pair<String, ArrayList<Integer>>>();
                tmpKeys.addAll(nodeKeys);
                tmpKeys.add(new Pair<String, ArrayList<Integer>>(k, child.getRowIndexes()));
                this.getAllSequentialKeys(child, result, tmpKeys);
            }
        }
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }
}

