/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource;

public class CloudInstance {
    private final String instanceName;
    private final double instancePrice;
    private final double extraStoragePrice;
    private final double extraFee;
    private final long memory;
    private final int vCPUCores;
    private final long flops;
    private final double memoryBandwidth;
    private final double diskReadBandwidth;
    private final double diskWriteBandwidth;
    private final double networkBandwidth;
    private final boolean NVMeStorage;
    private final int numberStorageVolumes;
    private final double sizeStorageVolumes;

    public CloudInstance(String instanceName, double pricePerHour, double extraFee, double storagePrice, long memory, int vCPUCores, double GFlops, double memoryBandwidth, double diskReadBandwidth, double diskWriteBandwidth, double networkBandwidth, boolean NVMeStorage, int numberStorageVolumes, double sizeStorageVolumes) {
        this.instanceName = instanceName;
        this.instancePrice = pricePerHour / 3600.0;
        this.extraFee = extraFee / 3600.0;
        this.extraStoragePrice = NVMeStorage ? 15.0 : storagePrice * (15.0 + (double)numberStorageVolumes * sizeStorageVolumes) / 2592000.0;
        this.memory = memory;
        this.vCPUCores = vCPUCores;
        this.flops = (long)(GFlops * 1024.0) * 1024L * 1024L;
        this.memoryBandwidth = memoryBandwidth;
        this.diskReadBandwidth = diskReadBandwidth;
        this.diskWriteBandwidth = diskWriteBandwidth;
        this.networkBandwidth = networkBandwidth;
        this.NVMeStorage = NVMeStorage;
        this.numberStorageVolumes = numberStorageVolumes;
        this.sizeStorageVolumes = sizeStorageVolumes;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public long getMemory() {
        return this.memory;
    }

    public int getVCPUs() {
        return this.vCPUCores;
    }

    public double getPrice() {
        return this.instancePrice;
    }

    public double getExtraStoragePrice() {
        return this.extraStoragePrice;
    }

    public double getExtraFee() {
        return this.extraFee;
    }

    public long getFLOPS() {
        return this.flops;
    }

    public double getMemoryBandwidth() {
        return this.memoryBandwidth;
    }

    public double getDiskReadBandwidth() {
        return this.diskReadBandwidth;
    }

    public double getDiskWriteBandwidth() {
        return this.diskWriteBandwidth;
    }

    public double getNetworkBandwidth() {
        return this.networkBandwidth;
    }

    public boolean isNVMeStorage() {
        return this.NVMeStorage;
    }

    public int getNumStorageVolumes() {
        return this.numberStorageVolumes;
    }

    public double getSizeStoragePerVolume() {
        return this.sizeStorageVolumes;
    }
}

