/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.StandaloneResourceUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceAllocation;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceRequirement;
import org.apache.spark.util.Utils$;
import org.json4s.DefaultFormats$;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class StandaloneResourceUtils$
implements Logging {
    public static StandaloneResourceUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StandaloneResourceUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<File> prepareResourcesFile(String componentName, Map<String, ResourceInformation> resources, File dir) {
        if (resources.isEmpty()) {
            return None$.MODULE$;
        }
        String compShortName = componentName.substring(componentName.lastIndexOf(".") + 1);
        File tmpFile = Utils$.MODULE$.tempFileWith(dir);
        Seq allocations = ((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                ResourceInformation rInfo = (ResourceInformation)tuple2._2();
                return new ResourceAllocation(new ResourceID(componentName, rName), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])rInfo.addresses()));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        try {
            this.writeResourceAllocationJson(allocations, tmpFile);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errMsg = new StringBuilder(50).append("Exception threw while preparing resource file for ").append(compShortName).toString();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg, e);
                throw new SparkException(errMsg, e);
            }
            throw throwable;
        }
        File resourcesFile = File.createTempFile(new StringBuilder(10).append("resource-").append(compShortName).append("-").toString(), ".json", dir);
        tmpFile.renameTo(resourcesFile);
        return new Some((Object)resourcesFile);
    }

    private <T> void writeResourceAllocationJson(Seq<T> allocations, File jsonFile) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue allocationJson = Extraction$.MODULE$.decompose(allocations, (Formats)formats);
        Files.write(jsonFile.toPath(), JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(allocationJson, (Formats)formats)).getBytes(), new OpenOption[0]);
    }

    public Map<String, StandaloneResourceUtils.MutableResourceInfo> toMutable(Map<String, ResourceInformation> immutableResources) {
        return (Map)immutableResources.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                ResourceInformation rInfo = (ResourceInformation)tuple2._2();
                HashSet mutableAddress = new HashSet();
                mutableAddress.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rInfo.addresses())));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rName), (Object)new StandaloneResourceUtils.MutableResourceInfo(rInfo.name(), (HashSet<String>)mutableAddress));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public String formatResourcesDetails(Map<String, ResourceInformation> usedInfo, Map<String, ResourceInformation> freeInfo) {
        return ((TraversableOnce)usedInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                ResourceInformation rInfo = (ResourceInformation)tuple2._2();
                String used = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rInfo.addresses())).mkString("[", ", ", "]");
                String free = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ResourceInformation)freeInfo.apply((Object)rName)).addresses())).mkString("[", ", ", "]");
                return new StringBuilder(17).append(rName).append(": Free: ").append(free).append(" / Used: ").append(used).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public String formatResourcesAddresses(Map<String, ResourceInformation> resources) {
        return ((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                ResourceInformation rInfo = (ResourceInformation)tuple2._2();
                return new StringBuilder(2).append(rName).append(": ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rInfo.addresses())).mkString("[", ", ", "]")).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public String formatResourcesUsed(Map<String, Object> resourcesTotal, Map<String, Object> resourcesUsed) {
        return ((TraversableOnce)resourcesTotal.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                int totalSize = tuple2._2$mcI$sp();
                int used = BoxesRunTime.unboxToInt((Object)resourcesUsed.apply((Object)rName));
                int total = totalSize;
                return new StringBuilder(4).append(used).append(" / ").append(total).append(" ").append(rName).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public String formatResourceRequirements(Seq<ResourceRequirement> requirements) {
        return ((TraversableOnce)requirements.map((Function1 & Serializable & scala.Serializable)req -> new StringBuilder(1).append(req.amount()).append(" ").append(req.resourceName()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private StandaloneResourceUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

