/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

public class DMLCompressionStatistics {
    private static double Phase0 = 0.0;
    private static double Phase1 = 0.0;
    private static double Phase2 = 0.0;
    private static double Phase3 = 0.0;
    private static double Phase4 = 0.0;
    private static double Phase5 = 0.0;
    private static int DecompressSTCount = 0;
    private static double DecompressST = 0.0;
    private static int DecompressMTCount = 0;
    private static double DecompressMT = 0.0;
    private static int DecompressToSTCount = 0;
    private static double DecompressToST = 0.0;
    private static int DecompressToMTCount = 0;
    private static double DecompressToMT = 0.0;
    private static int DecompressSparkCount = 0;
    private static int DecompressCacheCount = 0;

    public static void reset() {
        Phase0 = 0.0;
        Phase1 = 0.0;
        Phase2 = 0.0;
        Phase3 = 0.0;
        Phase4 = 0.0;
        Phase5 = 0.0;
        DecompressSTCount = 0;
        DecompressST = 0.0;
        DecompressMTCount = 0;
        DecompressMT = 0.0;
        DecompressToSTCount = 0;
        DecompressToST = 0.0;
        DecompressToMTCount = 0;
        DecompressToMT = 0.0;
        DecompressSparkCount = 0;
        DecompressCacheCount = 0;
    }

    public static boolean haveCompressed() {
        return Phase0 > 0.0;
    }

    public static void addCompressionTime(double time, int phase) {
        switch (phase) {
            case 0: {
                Phase0 += time;
                break;
            }
            case 1: {
                Phase1 += time;
                break;
            }
            case 2: {
                Phase2 += time;
                break;
            }
            case 3: {
                Phase3 += time;
                break;
            }
            case 4: {
                Phase4 += time;
                break;
            }
            case 5: {
                Phase5 += time;
            }
        }
    }

    public static void addDecompressTime(double time, int threads) {
        if (threads == 1) {
            ++DecompressSTCount;
            DecompressST += time;
        } else {
            ++DecompressMTCount;
            DecompressMT += time;
        }
    }

    public static void addDecompressToBlockTime(double time, int threads) {
        if (threads == 1) {
            ++DecompressToSTCount;
            DecompressToST += time;
        } else {
            ++DecompressToMTCount;
            DecompressToMT += time;
        }
    }

    public static void addDecompressSparkCount() {
        ++DecompressSTCount;
    }

    public static void addDecompressCacheCount() {
        ++DecompressCacheCount;
    }

    public static int getDecompressionCount() {
        return DecompressMTCount + DecompressSTCount + DecompressSparkCount + DecompressCacheCount + DecompressToSTCount + DecompressToMTCount;
    }

    public static void display(StringBuilder sb) {
        if (DMLCompressionStatistics.haveCompressed()) {
            sb.append(String.format("CLA Compression Phases :\t%.3f/%.3f/%.3f/%.3f/%.3f/%.3f\n", Phase0 / 1000.0, Phase1 / 1000.0, Phase2 / 1000.0, Phase3 / 1000.0, Phase4 / 1000.0, Phase5 / 1000.0));
            sb.append(String.format("Decompression with allocation (Single, Multi, Spark, Cache) : %d/%d/%d/%d\n", DecompressSTCount, DecompressMTCount, DecompressSparkCount, DecompressCacheCount));
            sb.append(String.format("Decompression with allocation Time (Single , Multi)         : %.3f/%.3f sec.\n", DecompressST / 1000.0, DecompressMT / 1000.0));
            sb.append(String.format("Decompression to block (Single, Multi)                      : %d/%d\n", DecompressToSTCount, DecompressToMTCount));
            sb.append(String.format("Decompression to block Time (Single, Multi)                 : %.3f/%.3f sec.\n", DecompressToST / 1000.0, DecompressToMT / 1000.0));
        }
    }
}

