/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.Util;

public abstract class ACount<T> {
    protected static final Log LOG = LogFactory.getLog((String)ACount.class.getName());
    public int count;
    public int id;

    public abstract ACount<T> next();

    public abstract void setNext(ACount<T> var1);

    public abstract T key();

    public abstract ACount<T> get(T var1);

    public abstract ACount<T> inc(T var1, int var2, int var3);

    public ACount<T> get(double key) {
        throw new NotImplementedException();
    }

    public ACount<T> inc(double key, int c, int id) {
        throw new NotImplementedException();
    }

    public ACount<T> sort() {
        Sorter s = new Sorter();
        s.sort(this);
        return s.sorted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key().toString());
        sb.append("=<");
        sb.append(this.id);
        sb.append(",");
        sb.append(this.count);
        sb.append(">");
        if (this.next() != null) {
            sb.append(" -> ");
            sb.append(this.next().toString());
        }
        return sb.toString();
    }

    private static class Sorter<T> {
        ACount<T> sorted = null;

        private Sorter() {
        }

        private void sort(ACount<T> head) {
            ACount<T> current = head;
            ACount<T> prev = null;
            ACount<T> next = null;
            while (current != null) {
                next = current.next();
                current.setNext(prev);
                prev = current;
                current = next;
            }
            while (prev != null) {
                next = prev.next();
                this.sortedInsert(prev);
                prev = next;
            }
        }

        private void sortedInsert(ACount<T> n) {
            if (this.sorted == null || this.sorted.count < n.count) {
                n.setNext(this.sorted);
                this.sorted = n;
            } else {
                ACount<T> c = this.sorted;
                while (c.next() != null && c.next().count > n.count) {
                    c = c.next();
                }
                n.setNext(c.next());
                c.setNext(n);
            }
        }
    }

    public static final class DCounts
    extends ACount<Double> {
        public final double key;
        public DCounts next;

        public DCounts(double key, int id) {
            this.key = key;
            this.id = id;
            this.count = 1;
        }

        public DCounts(double key, int id, int c) {
            this.key = key;
            this.id = id;
            this.count = c;
        }

        public final DCounts next() {
            return this.next;
        }

        @Override
        public final void setNext(ACount<Double> e) {
            this.next = (DCounts)e;
        }

        @Override
        public final Double key() {
            return this.key;
        }

        public DCounts sort() {
            return (DCounts)super.sort();
        }

        @Override
        public ACount<Double> get(Double key) {
            return this.get((double)key);
        }

        @Override
        public ACount<Double> get(double key) {
            DCounts e = this;
            while (e != null && !Util.eq(key, e.key)) {
                e = e.next;
            }
            return e;
        }

        public DCounts inc(Double key, int c, int id) {
            return this.inc((double)key, c, id);
        }

        public DCounts inc(double key, int c, int id) {
            DCounts e = this;
            while (e.next != null && !Util.eq(key, e.key)) {
                e = e.next;
            }
            if (Util.eq(key, e.key)) {
                e.count += c;
                return e;
            }
            e.next = new DCounts(key, id, c);
            return e.next;
        }

        public static final int hashIndex(double key) {
            long bits = Double.doubleToLongBits(key);
            return Math.abs((int)(bits ^ bits >>> 32));
        }
    }

    public static final class DArrCounts
    extends ACount<DblArray> {
        public final DblArray key;
        public DArrCounts next;

        public DArrCounts(DblArray key, int id) {
            this.key = new DblArray(key);
            this.id = id;
            this.count = 1;
        }

        public DArrCounts(DblArray key, int id, int count) {
            this.key = new DblArray(key);
            this.id = id;
            this.count = count;
        }

        public final DArrCounts next() {
            return this.next;
        }

        @Override
        public final void setNext(ACount<DblArray> e) {
            this.next = (DArrCounts)e;
        }

        @Override
        public final DblArray key() {
            return this.key;
        }

        @Override
        public final ACount<DblArray> get(DblArray key) {
            DArrCounts e = this;
            boolean eq = e.key.equals(key);
            while (e.next != null && !eq) {
                e = e.next;
                eq = e.key.equals(key);
            }
            return eq ? e : null;
        }

        public final DArrCounts inc(DblArray key, int c, int id) {
            DArrCounts e = this;
            if (e.key.equals(key)) {
                e.count += c;
                return e;
            }
            while (e.next != null) {
                e = e.next;
                if (!e.key.equals(key)) continue;
                e.count += c;
                return e;
            }
            e.next = new DArrCounts(key, id, c);
            return e.next;
        }
    }
}

