/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.List;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.CMOperator;

public class CLALibCMOps {
    public static CM_COV_Object centralMoment(CompressedMatrixBlock cmb, CMOperator op) {
        MatrixBlock.checkCMOperations(cmb, op);
        if (cmb.isEmpty()) {
            return LibMatrixAgg.aggregateCmCov(cmb, null, null, op.fn);
        }
        if (cmb.isOverlapping()) {
            return cmb.getUncompressed("cmOperations on overlapping state", op.getNumThreads()).cmOperations(op);
        }
        List<AColGroup> groups = cmb.getColGroups();
        if (groups.size() == 1) {
            return groups.get(0).centralMoment(op, cmb.getNumRows());
        }
        throw new DMLCompressionException("Unsupported case for cmOperations");
    }
}

