/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.lops.Lop;

public class MMCJ
extends Lop {
    private boolean _outputEmptyBlocks = true;
    private MMCJType _type = MMCJType.AGG;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public MMCJ(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, MMCJType type, Types.ExecType et) {
        super(Lop.Type.MMCJ, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._type = type;
        this.lps.setProperties(this.inputs, et);
    }

    public MMCJ(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, boolean outputEmptyBlocks, AggBinaryOp.SparkAggType aggtype, Types.ExecType et) {
        this(input1, input2, dt, vt, MMCJType.NO_AGG, et);
        this._outputEmptyBlocks = outputEmptyBlocks;
        this._aggtype = aggtype;
    }

    @Override
    public AggBinaryOp.SparkAggType getAggType() {
        return this._aggtype;
    }

    @Override
    public String toString() {
        return "Operation = MMCJ";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append("cpmm");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        if (this.getExecType() == Types.ExecType.SPARK) {
            sb.append(this._outputEmptyBlocks);
            sb.append("\u00b0");
            sb.append(this._aggtype.name());
        } else {
            sb.append(this._type.name());
        }
        return sb.toString();
    }

    public static enum MMCJType {
        AGG,
        NO_AGG;

    }
}

