/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import org.apache.log4j.Logger;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.controlprogram.federated.ExecutionContextMap;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandler;

public class FederatedWorker {
    protected static Logger log = Logger.getLogger(FederatedWorker.class);
    private int _port;
    private final ExecutionContextMap _ecm = new ExecutionContextMap();

    public FederatedWorker(int port) {
        this._port = port == -1 ? 4040 : port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws CertificateException, SSLException {
        log.info((Object)"Setting up Federated Worker");
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(1);
        ServerBootstrap b = new ServerBootstrap();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        final SslContext cont2 = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).build();
        try {
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline cp = ch.pipeline();
                    if (ConfigurationManager.getDMLConfig().getBooleanValue("sysds.federated.ssl")) {
                        cp.addLast(new ChannelHandler[]{cont2.newHandler(ch.alloc())});
                    }
                    cp.addLast("ObjectDecoder", (ChannelHandler)new ObjectDecoder(Integer.MAX_VALUE, ClassResolvers.weakCachingResolver((ClassLoader)ClassLoader.getSystemClassLoader())));
                    cp.addLast("ObjectEncoder", (ChannelHandler)new ObjectEncoder());
                    cp.addLast("FederatedWorkerHandler", (ChannelHandler)new FederatedWorkerHandler(FederatedWorker.this._ecm));
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            log.info((Object)("Starting Federated Worker server at port: " + this._port));
            ChannelFuture f = b.bind(this._port).sync();
            log.info((Object)("Started Federated Worker at port: " + this._port));
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            log.info((Object)"Federated worker interrupted");
        }
        finally {
            log.info((Object)"Federated Worker Shutting down.");
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

