/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.finegrained;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.finegrained.DataRange;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacy;

public class FineGrainedPrivacyList
implements FineGrainedPrivacy {
    private ArrayList<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>> constraintCollection = new ArrayList();

    @Override
    public PrivacyConstraint.PrivacyLevel[] getRowPrivacy(int numRows, int numCols) {
        PrivacyConstraint.PrivacyLevel[] privacyLevels = new PrivacyConstraint.PrivacyLevel[numRows];
        for (int i = 0; i < numRows; ++i) {
            long[] beginRange1 = new long[]{i, 0L};
            long[] endRange1 = new long[]{i, numCols};
            privacyLevels[i] = this.getStrictestPrivacyLevel(new DataRange(beginRange1, endRange1));
        }
        return privacyLevels;
    }

    @Override
    public PrivacyConstraint.PrivacyLevel[] getColPrivacy(int numRows, int numCols) {
        PrivacyConstraint.PrivacyLevel[] privacyLevels = new PrivacyConstraint.PrivacyLevel[numCols];
        for (int i = 0; i < numCols; ++i) {
            long[] beginRange = new long[]{0L, i};
            long[] endRange = new long[]{numRows, i};
            privacyLevels[i] = this.getStrictestPrivacyLevel(new DataRange(beginRange, endRange));
        }
        return privacyLevels;
    }

    private PrivacyConstraint.PrivacyLevel getStrictestPrivacyLevel(DataRange searchRange) {
        PrivacyConstraint.PrivacyLevel strictestLevel = PrivacyConstraint.PrivacyLevel.None;
        for (Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel> constraint : this.constraintCollection) {
            if (!constraint.getKey().overlaps(searchRange)) continue;
            if (constraint.getValue() == PrivacyConstraint.PrivacyLevel.Private) {
                return PrivacyConstraint.PrivacyLevel.Private;
            }
            if (constraint.getValue() != PrivacyConstraint.PrivacyLevel.PrivateAggregation) continue;
            strictestLevel = PrivacyConstraint.PrivacyLevel.PrivateAggregation;
        }
        return strictestLevel;
    }

    @Override
    public void put(DataRange dataRange, PrivacyConstraint.PrivacyLevel privacyLevel) {
        this.constraintCollection.add(new AbstractMap.SimpleEntry<DataRange, PrivacyConstraint.PrivacyLevel>(dataRange, privacyLevel));
    }

    @Override
    public void putRow(int rowIndex, int rowLength, PrivacyConstraint.PrivacyLevel privacyLevel) {
        this.put(new DataRange(new long[]{rowIndex, 0L}, new long[]{rowIndex, rowLength - 1}), privacyLevel);
    }

    @Override
    public void putCol(int colIndex, int colLength, PrivacyConstraint.PrivacyLevel privacyLevel) {
        this.put(new DataRange(new long[]{0L, colIndex}, new long[]{colLength - 1, colIndex}), privacyLevel);
    }

    @Override
    public void putElement(int rowIndex, int colIndex, PrivacyConstraint.PrivacyLevel privacyLevel) {
        this.put(new DataRange(new long[]{rowIndex, colIndex}, new long[]{rowIndex, colIndex}), privacyLevel);
    }

    @Override
    public Map<DataRange, PrivacyConstraint.PrivacyLevel> getPrivacyLevel(DataRange searchRange) {
        LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel> matches = new LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel>();
        for (Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel> constraint : this.constraintCollection) {
            if (!constraint.getKey().overlaps(searchRange)) continue;
            matches.put(constraint.getKey(), constraint.getValue());
        }
        return matches;
    }

    @Override
    public Map<DataRange, PrivacyConstraint.PrivacyLevel> getPrivacyLevelOfElement(long[] searchIndex) {
        LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel> matches = new LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel>();
        this.constraintCollection.forEach((Consumer<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>>)((Consumer<Map.Entry>)constraint -> {
            if (((DataRange)constraint.getKey()).contains(searchIndex)) {
                matches.put((DataRange)constraint.getKey(), (PrivacyConstraint.PrivacyLevel)((Object)constraint.getValue()));
            }
        }));
        return matches;
    }

    @Override
    public DataRange[] getDataRangesOfPrivacyLevel(PrivacyConstraint.PrivacyLevel privacyLevel) {
        ArrayList matches = new ArrayList();
        this.constraintCollection.forEach((Consumer<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>>)((Consumer<Map.Entry>)constraint -> {
            if (constraint.getValue() == privacyLevel) {
                matches.add(constraint.getKey());
            }
        }));
        return matches.toArray(new DataRange[0]);
    }

    @Override
    public void removeAllConstraints() {
        this.constraintCollection.clear();
    }

    @Override
    public boolean hasConstraints() {
        return !this.constraintCollection.isEmpty();
    }

    @Override
    public Map<String, long[][][]> getAllConstraints() {
        ArrayList privateRanges = new ArrayList();
        ArrayList aggregateRanges = new ArrayList();
        this.constraintCollection.forEach((Consumer<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>>)((Consumer<Map.Entry>)constraint -> {
            if (constraint.getValue() == PrivacyConstraint.PrivacyLevel.Private) {
                privateRanges.add(new long[][]{((DataRange)constraint.getKey()).getBeginDims(), ((DataRange)constraint.getKey()).getEndDims()});
            } else if (constraint.getValue() == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                aggregateRanges.add(new long[][]{((DataRange)constraint.getKey()).getBeginDims(), ((DataRange)constraint.getKey()).getEndDims()});
            }
        }));
        HashMap<String, long[][][]> constraintMap = new HashMap<String, long[][][]>();
        constraintMap.put(PrivacyConstraint.PrivacyLevel.Private.name(), (long[][][])privateRanges.toArray((T[])new long[0][][]));
        constraintMap.put(PrivacyConstraint.PrivacyLevel.PrivateAggregation.name(), (long[][][])privateRanges.toArray((T[])new long[0][][]));
        return constraintMap;
    }

    @Override
    public ArrayList<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>> getAllConstraintsList() {
        return this.constraintCollection;
    }

    public boolean equals(Object other) {
        if (other instanceof FineGrainedPrivacyList) {
            FineGrainedPrivacyList otherFGP = (FineGrainedPrivacyList)other;
            if (!otherFGP.hasConstraints() && !this.hasConstraints()) {
                return true;
            }
            if (!otherFGP.hasConstraints() || !this.hasConstraints()) {
                return false;
            }
            return otherFGP.getAllConstraintsList().equals(this.constraintCollection);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel> entry : this.constraintCollection) {
            stringBuilder.append(entry.getKey().toString() + " : " + entry.getValue().name());
        }
        return stringBuilder.toString();
    }
}

