/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class BinaryMatrixMatrixFEDInstruction
extends BinaryFEDInstruction {
    protected BinaryMatrixMatrixFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.Binary, op, in1, in2, out, opcode, istr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        FederatedRequest[] fr1;
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        MatrixObject mo2 = ec.getMatrixObject(this.input2);
        FederatedRequest fr2 = null;
        if (mo2.isFederated()) {
            if (!mo1.isFederated() || !mo1.getFedMapping().isAligned(mo2.getFedMapping(), false)) throw new DMLRuntimeException("Matrix-matrix binary operations  with a federated right input are not supported yet.");
            fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID()});
            mo1.getFedMapping().execute(this.getTID(), true, fr2);
        } else if (mo2.getNumRows() > 1L && mo2.getNumColumns() == 1L) {
            fr1 = mo1.getFedMapping().broadcastSliced(mo2, false);
            fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), fr1[0].getID()});
            FederatedRequest fr3 = mo1.getFedMapping().cleanup(this.getTID(), fr1[0].getID());
            mo1.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2, fr3});
        } else {
            fr1 = mo1.getFedMapping().broadcast(mo2);
            fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), fr1.getID()});
            FederatedRequest fr3 = mo1.getFedMapping().cleanup(this.getTID(), fr1.getID());
            mo1.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1, fr2, fr3});
        }
        MatrixObject out = ec.getMatrixObject(this.output);
        out.getDataCharacteristics().set(mo1.getDataCharacteristics());
        out.setFedMapping(mo1.getFedMapping().copyWithNewID(fr2.getID()));
    }
}

