/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sysml.runtime.io.IOUtilFunctions;

public class CompactInputFormat<K extends WritableComparable, V extends Writable>
extends FileInputFormat<K, V> {
    public static final String KEY_CLASS = "compact.fixed.length.input.key.class";
    public static final String VALUE_CLASS = "compact.fixed.length.input.value.class";

    public static void setKeyValueClasses(JobConf job, Class<? extends WritableComparable> keyClass, Class<? extends Writable> valueClass) {
        job.setClass(KEY_CLASS, keyClass, WritableComparable.class);
        job.setClass(VALUE_CLASS, valueClass, Writable.class);
    }

    @Override
    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new CompactInputRecordReader(job, (FileSplit)split);
    }

    @Override
    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    public static class CompactInputRecordReader<K extends WritableComparable, V extends Writable>
    implements RecordReader<K, V> {
        protected long totLength;
        protected FileSystem fs;
        protected Path path;
        protected Class<? extends WritableComparable> keyClass;
        protected Class<? extends Writable> valueClass;
        protected JobConf conf;
        protected FSDataInputStream currentStream;

        public CompactInputRecordReader(JobConf job, FileSplit split) throws IOException {
            this.path = split.getPath();
            this.fs = IOUtilFunctions.getFileSystem(this.path, job);
            this.totLength = split.getLength();
            this.currentStream = this.fs.open(this.path);
            this.keyClass = job.getClass(CompactInputFormat.KEY_CLASS, WritableComparable.class);
            this.valueClass = job.getClass(CompactInputFormat.VALUE_CLASS, Writable.class);
        }

        @Override
        public void close() throws IOException {
            IOUtilFunctions.closeSilently(this.currentStream);
        }

        @Override
        public K createKey() {
            return (K)ReflectionUtils.newInstance(this.keyClass, this.conf);
        }

        @Override
        public V createValue() {
            return (V)ReflectionUtils.newInstance(this.valueClass, this.conf);
        }

        @Override
        public long getPos() throws IOException {
            long currentOffset = this.currentStream == null ? 0L : this.currentStream.getPos();
            return currentOffset;
        }

        @Override
        public float getProgress() throws IOException {
            return this.totLength == 0L ? 0.0f : (float)this.getPos() / (float)this.totLength;
        }

        @Override
        public boolean next(K key, V value) throws IOException {
            if (this.currentStream.getPos() < this.totLength) {
                key.readFields(this.currentStream);
                value.readFields(this.currentStream);
                return true;
            }
            return false;
        }
    }
}

