/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixPackedCell;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;

public class GMRCombiner
extends ReduceBase
implements Reducer<MatrixIndexes, TaggedMatrixValue, MatrixIndexes, TaggedMatrixValue> {
    private TaggedMatrixValue taggedbuffer = null;

    public void reduce(MatrixIndexes indexes, Iterator<TaggedMatrixValue> values, OutputCollector<MatrixIndexes, TaggedMatrixValue> out, Reporter report) throws IOException {
        long start = System.currentTimeMillis();
        this.cachedValues.reset();
        this.processAggregateInstructions(indexes, values, true);
        this.outputInCombinerFromCachedValues(indexes, this.taggedbuffer, out);
        report.incrCounter(ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        if (this.valueClass.equals(MatrixCell.class)) {
            this.valueClass = MatrixPackedCell.class;
        }
        this.taggedbuffer = TaggedMatrixValue.createObject(this.valueClass);
    }
}

