/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CSVReBlock
extends Lop {
    public static final String OPCODE = "csvrblk";
    private int _rows_per_block;
    private int _cols_per_block;

    public CSVReBlock(Lop input, int rows_per_block, int cols_per_block, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.CSVReBlock, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._rows_per_block = rows_per_block;
        this._cols_per_block = cols_per_block;
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = true;
        this.lps.addCompatibility(JobType.CSV_REBLOCK);
        if (et == LopProperties.ExecType.MR) {
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
        } else if (et == LopProperties.ExecType.SPARK) {
            this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        } else {
            throw new LopsException("Incorrect execution type for CSVReblock:" + (Object)((Object)et));
        }
    }

    @Override
    public String toString() {
        return "CSVReblock - rows per block = " + this._rows_per_block + " cols per block  " + this._cols_per_block;
    }

    private String prepCSVProperties() {
        StringBuilder sb = new StringBuilder();
        Data dataInput = (Data)this.getInputs().get(0);
        Lop headerLop = dataInput.getNamedInputLop("header", String.valueOf(false));
        Lop delimLop = dataInput.getNamedInputLop("sep", ",");
        Lop fillLop = dataInput.getNamedInputLop("fill", String.valueOf(true));
        Lop fillValueLop = dataInput.getNamedInputLop("default", String.valueOf(0.0));
        if (headerLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "header" + " must be a literal.");
        }
        if (delimLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "sep" + " must be a literal.");
        }
        if (fillLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "fill" + " must be a literal.");
        }
        if (fillValueLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "default" + " must be a literal.");
        }
        sb.append(((Data)headerLop).getBooleanValue());
        sb.append("\u00b0");
        sb.append(((Data)delimLop).getStringValue());
        sb.append("\u00b0");
        sb.append(((Data)fillLop).getBooleanValue());
        sb.append("\u00b0");
        sb.append(((Data)fillValueLop).getDoubleValue());
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append(this._rows_per_block);
        sb.append("\u00b0");
        sb.append(this._cols_per_block);
        sb.append("\u00b0");
        sb.append(this.prepCSVProperties());
        return sb.toString();
    }
}

