/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.DMLOptions;
import org.apache.sysml.api.ScriptExecutorUtils;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.debug.DMLDebugger;
import org.apache.sysml.debug.DMLDebuggerProgramInfo;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DMLTranslator;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParserFactory;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CleanupMR;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.NativeHelper;
import org.apache.sysml.utils.Statistics;
import org.apache.sysml.yarn.DMLAppMasterUtils;
import org.apache.sysml.yarn.DMLYarnClientProxy;

public class DMLScript {
    public static RUNTIME_PLATFORM rtplatform = DMLOptions.defaultOptions.execMode;
    public static boolean STATISTICS = DMLOptions.defaultOptions.stats;
    public static boolean FINEGRAINED_STATISTICS = false;
    public static boolean JMLC_MEM_STATISTICS = false;
    public static int STATISTICS_COUNT = DMLOptions.defaultOptions.statsCount;
    public static int STATISTICS_MAX_WRAP_LEN = 30;
    public static boolean ENABLE_DEBUG_MODE = DMLOptions.defaultOptions.debug;
    public static Explain.ExplainType EXPLAIN = DMLOptions.defaultOptions.explainType;
    public static String DML_FILE_PATH_ANTLR_PARSER = DMLOptions.defaultOptions.filePath;
    public static String FLOATING_POINT_PRECISION = "double";
    public static EvictionPolicy GPU_EVICTION_POLICY = EvictionPolicy.MIN_EVICT;
    public static boolean PRINT_GPU_MEMORY_INFO = false;
    public static long EVICTION_SHADOW_BUFFER_MAX_BYTES = 0L;
    public static long EVICTION_SHADOW_BUFFER_CURR_BYTES = 0L;
    public static double GPU_MEMORY_UTILIZATION_FACTOR = 0.9;
    public static String GPU_MEMORY_ALLOCATOR = "cuda";
    public static ScriptType SCRIPT_TYPE = DMLOptions.defaultOptions.scriptType;
    public static boolean USE_ACCELERATOR = DMLOptions.defaultOptions.gpu;
    public static boolean FORCE_ACCELERATOR = DMLOptions.defaultOptions.forceGPU;
    public static boolean SYNCHRONIZE_GPU = true;
    public static boolean EAGER_CUDA_FREE = false;
    public static boolean _suppressPrint2Stdout = false;
    public static boolean USE_LOCAL_SPARK_CONFIG = false;
    public static boolean _activeAM = false;
    public static boolean VALIDATOR_IGNORE_ISSUES = false;
    public static String _uuid = IDHandler.createDistributedUniqueID();
    private static final Log LOG = LogFactory.getLog(DMLScript.class.getName());

    public static String getUUID() {
        return _uuid;
    }

    public static void setUUID(String uuid) {
        _uuid = uuid;
    }

    public static boolean suppressPrint2Stdout() {
        return _suppressPrint2Stdout;
    }

    public static void setActiveAM() {
        _activeAM = true;
    }

    public static boolean isActiveAM() {
        return _activeAM;
    }

    public static void main(String[] args) throws IOException {
        Configuration conf = new Configuration(ConfigurationManager.getCachedJobConf());
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        try {
            DMLScript.executeScript(conf, otherArgs);
        }
        catch (org.apache.sysml.parser.ParseException pe) {
            System.err.println(pe.getMessage());
        }
        catch (DMLScriptException e) {
            System.err.println(e.getMessage());
        }
    }

    public static boolean executeScript(Configuration conf, String[] args) {
        RUNTIME_PLATFORM oldrtplatform = rtplatform;
        Explain.ExplainType oldexplain = EXPLAIN;
        DMLOptions dmlOptions = null;
        try {
            dmlOptions = DMLOptions.parseCLArguments(args);
            STATISTICS = dmlOptions.stats;
            STATISTICS_COUNT = dmlOptions.statsCount;
            JMLC_MEM_STATISTICS = dmlOptions.memStats;
            USE_ACCELERATOR = dmlOptions.gpu;
            FORCE_ACCELERATOR = dmlOptions.forceGPU;
            EXPLAIN = dmlOptions.explainType;
            ENABLE_DEBUG_MODE = dmlOptions.debug;
            SCRIPT_TYPE = dmlOptions.scriptType;
            rtplatform = dmlOptions.execMode;
            String fnameOptConfig = dmlOptions.configFile;
            boolean isFile = dmlOptions.filePath != null;
            String fileOrScript = isFile ? dmlOptions.filePath : dmlOptions.script;
            boolean help = dmlOptions.help;
            if (help) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("systemml", dmlOptions.options);
                boolean bl = true;
                return bl;
            }
            if (dmlOptions.clean) {
                DMLScript.cleanSystemMLWorkspace();
                boolean formatter = true;
                return formatter;
            }
            if (!ENABLE_DEBUG_MODE) {
                DMLScript.setLoggingProperties(conf);
            }
            if (isFile && StringUtils.endsWithIgnoreCase(fileOrScript, ".pydml")) {
                SCRIPT_TYPE = ScriptType.PYDML;
            }
            String dmlScriptStr = DMLScript.readDMLScript(isFile, fileOrScript);
            Map<String, String> argVals = dmlOptions.argVals;
            DML_FILE_PATH_ANTLR_PARSER = dmlOptions.filePath;
            DMLScript.printInvocationInfo(fileOrScript, fnameOptConfig, argVals);
            if (ENABLE_DEBUG_MODE) {
                DMLScript.launchDebugger(dmlScriptStr, fnameOptConfig, argVals, SCRIPT_TYPE);
            } else {
                DMLScript.execute(dmlScriptStr, fnameOptConfig, argVals, args, SCRIPT_TYPE);
            }
        }
        catch (AlreadySelectedException e) {
            System.err.println("Mutually exclusive options were selected. " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("systemml", dmlOptions.options);
            boolean bl = false;
            return bl;
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("systemml", dmlOptions.options);
        }
        catch (org.apache.sysml.parser.ParseException | DMLScriptException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.error("Failed to execute DML script.", ex);
            throw new DMLException(ex);
        }
        finally {
            rtplatform = oldrtplatform;
            EXPLAIN = oldexplain;
        }
        return true;
    }

    protected static String readDMLScript(boolean isFile, String scriptOrFilename) throws IOException {
        String dmlScriptStr;
        block11: {
            block9: {
                if (!isFile) break block9;
                String fileName = scriptOrFilename;
                if (fileName == null) {
                    throw new LanguageException("DML script path was not specified!");
                }
                StringBuilder sb = new StringBuilder();
                BufferedReader in = null;
                try {
                    if (fileName.startsWith("hdfs:") || fileName.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(fileName))) {
                        Path scriptPath = new Path(fileName);
                        FileSystem fs = IOUtilFunctions.getFileSystem(scriptPath);
                        in = new BufferedReader(new InputStreamReader(fs.open(scriptPath)));
                    } else {
                        in = new BufferedReader(new FileReader(fileName));
                    }
                    String tmp = null;
                    while ((tmp = in.readLine()) != null) {
                        sb.append(tmp);
                        sb.append("\n");
                    }
                }
                catch (IOException ex) {
                    try {
                        LOG.error("Failed to read the script from the file system", ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(in);
                        throw throwable;
                    }
                }
                IOUtilFunctions.closeSilently(in);
                dmlScriptStr = sb.toString();
                break block11;
            }
            String scriptString = scriptOrFilename;
            if (scriptString == null) {
                throw new LanguageException("DML script was not specified!");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(scriptString.getBytes());
            Scanner scan = new Scanner(is);
            dmlScriptStr = scan.useDelimiter("\\A").next();
            scan.close();
        }
        return dmlScriptStr;
    }

    private static void setLoggingProperties(Configuration conf) {
        String debug = conf.get("systemml.logging");
        if (debug == null) {
            debug = System.getProperty("systemml.logging");
        }
        if (debug != null) {
            if (debug.equalsIgnoreCase("debug")) {
                Logger.getLogger("org.apache.sysml").setLevel(Level.DEBUG);
            } else if (debug.equalsIgnoreCase("trace")) {
                Logger.getLogger("org.apache.sysml").setLevel(Level.TRACE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(String dmlScriptStr, String fnameOptConfig, Map<String, String> argVals, String[] allArgs, ScriptType scriptType) throws IOException {
        SCRIPT_TYPE = scriptType;
        DMLScript.printStartExecInfo(dmlScriptStr);
        DMLConfig dmlconf = DMLConfig.readConfigurationFile(fnameOptConfig);
        ConfigurationManager.setGlobalConfig(dmlconf);
        CompilerConfig cconf = OptimizerUtils.constructCompilerConfig(dmlconf);
        ConfigurationManager.setGlobalConfig(cconf);
        LOG.debug("\nDML config: \n" + dmlconf.getConfigInfo());
        DMLScript.setGlobalFlags(dmlconf);
        if (dmlconf.getBooleanValue("sysml.yarn.appmaster")) {
            DMLAppMasterUtils.setupConfigRemoteMaxMemory(dmlconf);
        }
        Statistics.startCompileTimer();
        ParserWrapper parser = ParserFactory.createParser(scriptType);
        DMLProgram prog = parser.parse(DML_FILE_PATH_ANTLR_PARSER, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        DMLScript.initHadoopExecution(dmlconf);
        dmlt.rewriteHopsDAG(prog);
        dmlt.constructLops(prog);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\n********************** LOPS DAG *******************");
            dmlt.printLops(prog);
            dmlt.resetLopsDAGVisitStatus(prog);
        }
        Program rtprog = dmlt.getRuntimeProgram(prog, dmlconf);
        if (dmlconf.getBooleanValue("sysml.yarn.appmaster")) {
            if (!DMLScript.isActiveAM() && DMLYarnClientProxy.launchDMLYarnAppmaster(dmlScriptStr, dmlconf, allArgs, rtprog)) {
                return;
            }
            if (DMLScript.isActiveAM()) {
                DMLAppMasterUtils.setupProgramMappingRemoteMaxMemory(rtprog);
            }
        }
        Explain.ExplainCounts counts = Explain.countDistributedOperations(rtprog);
        Statistics.resetNoOfCompiledJobs(counts.numJobs);
        if (EXPLAIN != Explain.ExplainType.NONE) {
            System.out.println(Explain.display(prog, rtprog, EXPLAIN, counts));
        }
        Statistics.stopCompileTimer();
        ExecutionContext ec = null;
        try {
            ec = ExecutionContextFactory.createContext(rtprog);
            ScriptExecutorUtils.executeRuntimeProgram(rtprog, ec, dmlconf, STATISTICS ? STATISTICS_COUNT : 0, null);
        }
        finally {
            if (ec != null && ec instanceof SparkExecutionContext) {
                ((SparkExecutionContext)ec).close();
            }
            LOG.info("END DML run " + DMLScript.getDateTime());
            DMLScript.cleanupHadoopExecution(dmlconf);
        }
    }

    public static void setGlobalFlags(DMLConfig dmlconf) {
        GPUContextPool.AVAILABLE_GPUS = dmlconf.getTextValue("sysml.gpu.availableGPUs");
        String evictionPolicy = dmlconf.getTextValue("sysml.gpu.eviction.policy").toUpperCase();
        try {
            GPU_EVICTION_POLICY = EvictionPolicy.valueOf(evictionPolicy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unsupported eviction policy:" + evictionPolicy);
        }
        FINEGRAINED_STATISTICS = STATISTICS && dmlconf.getBooleanValue("sysml.stats.finegrained");
        CacheableData.CACHING_BUFFER_SIZE = dmlconf.getDoubleValue("sysml.caching.bufferSize");
        if (CacheableData.CACHING_BUFFER_SIZE < 0.0 || CacheableData.CACHING_BUFFER_SIZE > 1.0) {
            throw new RuntimeException("Incorrect value (" + CacheableData.CACHING_BUFFER_SIZE + ") for the configuration " + "sysml.caching.bufferSize");
        }
        STATISTICS_MAX_WRAP_LEN = dmlconf.getIntValue("sysml.stats.maxWrapLength");
        NativeHelper.initialize(dmlconf.getTextValue("sysml.native.blas.directory"), dmlconf.getTextValue("sysml.native.blas").trim());
        SYNCHRONIZE_GPU = dmlconf.getBooleanValue("sysml.gpu.sync.postProcess");
        EAGER_CUDA_FREE = dmlconf.getBooleanValue("sysml.gpu.eager.cudaFree");
        PRINT_GPU_MEMORY_INFO = dmlconf.getBooleanValue("sysml.gpu.print.memoryInfo");
        GPU_MEMORY_UTILIZATION_FACTOR = dmlconf.getDoubleValue("sysml.gpu.memory.util.factor");
        GPU_MEMORY_ALLOCATOR = dmlconf.getTextValue("sysml.gpu.memory.allocator");
        if (GPU_MEMORY_UTILIZATION_FACTOR < 0.0) {
            throw new RuntimeException("Incorrect value (" + GPU_MEMORY_UTILIZATION_FACTOR + ") for the configuration:" + "sysml.gpu.memory.util.factor");
        }
        FLOATING_POINT_PRECISION = dmlconf.getTextValue("sysml.floating.point.precision");
        LibMatrixCUDA.resetFloatingPointPrecision();
        if (FLOATING_POINT_PRECISION.equals("double")) {
            EVICTION_SHADOW_BUFFER_MAX_BYTES = 0L;
        } else {
            double shadowBufferSize = dmlconf.getDoubleValue("sysml.gpu.eviction.shadow.bufferSize");
            if (shadowBufferSize < 0.0 || shadowBufferSize > 1.0) {
                throw new RuntimeException("Incorrect value (" + shadowBufferSize + ") for the configuration:" + "sysml.gpu.eviction.shadow.bufferSize");
            }
            EVICTION_SHADOW_BUFFER_MAX_BYTES = (long)((double)InfrastructureAnalyzer.getLocalMaxMemory() * shadowBufferSize);
            if (EVICTION_SHADOW_BUFFER_MAX_BYTES > 0L && EVICTION_SHADOW_BUFFER_CURR_BYTES > EVICTION_SHADOW_BUFFER_MAX_BYTES) {
                System.out.println("WARN: Cannot use the shadow buffer due to potentially cached GPU objects. Current shadow buffer size (in bytes):" + EVICTION_SHADOW_BUFFER_CURR_BYTES + " > Max shadow buffer size (in bytes):" + EVICTION_SHADOW_BUFFER_MAX_BYTES);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchDebugger(String dmlScriptStr, String fnameOptConfig, Map<String, String> argVals, ScriptType scriptType) throws IOException {
        DMLDebuggerProgramInfo dbprog = new DMLDebuggerProgramInfo();
        DMLConfig conf = DMLConfig.readConfigurationFile(fnameOptConfig);
        ConfigurationManager.setGlobalConfig(conf);
        ParserWrapper parser = ParserFactory.createParser(scriptType);
        DMLProgram prog = parser.parse(DML_FILE_PATH_ANTLR_PARSER, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        dmlt.rewriteHopsDAG(prog);
        dmlt.constructLops(prog);
        dbprog.rtprog = dmlt.getRuntimeProgram(prog, conf);
        try {
            DMLScript.initHadoopExecution(conf);
            DMLDebugger SystemMLdb = new DMLDebugger(dbprog, dmlScriptStr);
            SystemMLdb.runSystemMLDebugger();
        }
        finally {
            DMLScript.cleanupHadoopExecution(conf);
        }
    }

    public static void initHadoopExecution(DMLConfig config) throws IOException, org.apache.sysml.parser.ParseException, DMLRuntimeException {
        DMLScript.checkSecuritySetup(config);
        String scratch = config.getTextValue("sysml.scratch");
        MapReduceTool.createDirIfNotExistOnHDFS(scratch, "777");
        DMLScript.cleanupHadoopExecution(config);
        LocalFileUtils.createWorkingDirectory();
        CacheableData.initCaching();
        Statistics.resetNoOfExecutedJobs();
        if (STATISTICS) {
            Statistics.reset();
        }
    }

    private static void checkSecuritySetup(DMLConfig config) throws IOException, DMLRuntimeException {
        String userName = System.getProperty("user.name");
        HashSet groupNames = new HashSet();
        try {
            if (UserGroupInformation.class.getMethod("getCurrentUser", new Class[0]) != null) {
                String[] groups = UserGroupInformation.getCurrentUser().getGroupNames();
                Collections.addAll(groupNames, groups);
            }
        }
        catch (Exception groups) {
            // empty catch block
        }
        JobConf job = ConfigurationManager.getCachedJobConf();
        boolean localMode = InfrastructureAnalyzer.isLocalMode(job);
        String taskController = job.get(MRConfigurationNames.MR_TASKTRACKER_TASKCONTROLLER, "org.apache.hadoop.mapred.DefaultTaskController");
        String ttGroupName = job.get("mapreduce.tasktracker.group", "null");
        String perm = job.get(MRConfigurationNames.DFS_PERMISSIONS_ENABLED, "null");
        URI fsURI = FileSystem.getDefaultUri(job);
        boolean flagDiffUser = !taskController.equals("org.apache.hadoop.mapred.LinuxTaskController") && !localMode && !groupNames.contains(ttGroupName);
        boolean flagLocalFS = fsURI == null || fsURI.getScheme().equals("file");
        boolean flagSecurity = perm.equals("yes");
        LOG.debug("SystemML security check: local.user.name = " + userName + ", local.user.groups = " + Arrays.toString(groupNames.toArray()) + ", " + MRConfigurationNames.MR_JOBTRACKER_ADDRESS + " = " + job.get(MRConfigurationNames.MR_JOBTRACKER_ADDRESS) + ", " + MRConfigurationNames.MR_TASKTRACKER_TASKCONTROLLER + " = " + taskController + "," + "mapreduce.tasktracker.group" + " = " + ttGroupName + ", " + MRConfigurationNames.FS_DEFAULTFS + " = " + (fsURI != null ? fsURI.getScheme() : "null") + ", " + MRConfigurationNames.DFS_PERMISSIONS_ENABLED + " = " + perm);
        if (flagDiffUser && (flagLocalFS || flagSecurity)) {
            LOG.warn("Cannot run map/reduce tasks as user '" + userName + "'. Using tasktracker group '" + ttGroupName + "'.");
        }
    }

    public static void cleanupHadoopExecution(DMLConfig config) throws IOException, org.apache.sysml.parser.ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        String dirSuffix = sb.toString();
        MapReduceTool.deleteFileIfExistOnHDFS(config.getTextValue("sysml.scratch") + dirSuffix);
        JobConf job = new JobConf(ConfigurationManager.getCachedJobConf());
        if (InfrastructureAnalyzer.isLocalMode(job)) {
            try {
                LocalFileUtils.deleteFileIfExists(DMLConfig.LOCAL_MR_MODE_STAGING_DIR + dirSuffix);
                LocalFileUtils.deleteFileIfExists(MRJobConfiguration.getLocalWorkingDirPrefix(job) + dirSuffix);
                MapReduceTool.deleteFileIfExistOnHDFS(MRJobConfiguration.getSystemWorkingDirPrefix(job) + dirSuffix);
                MapReduceTool.deleteFileIfExistOnHDFS(MRJobConfiguration.getStagingWorkingDirPrefix(job) + dirSuffix);
            }
            catch (Exception ex) {
                LOG.warn("Unable to cleanup hadoop working dirs: " + ex.getMessage());
            }
        }
        CacheableData.cleanupCacheDir();
        LocalFileUtils.cleanupWorkingDirectory();
    }

    private static void printInvocationInfo(String fnameScript, String fnameOptConfig, Map<String, String> argVals) {
        LOG.debug("****** args to DML Script ******\nUUID: " + DMLScript.getUUID() + "\nSCRIPT PATH: " + fnameScript + "\nRUNTIME: " + (Object)((Object)rtplatform) + "\nBUILTIN CONFIG: " + "./SystemML-config.xml" + "\nOPTIONAL CONFIG: " + fnameOptConfig + "\n");
        if (!argVals.isEmpty()) {
            LOG.debug("Script arguments are: \n");
            for (int i = 1; i <= argVals.size(); ++i) {
                LOG.debug("Script argument $" + i + " = " + argVals.get("$" + i));
            }
        }
    }

    private static void printStartExecInfo(String dmlScriptString) {
        LOG.info("BEGIN DML run " + DMLScript.getDateTime());
        LOG.debug("DML script: \n" + dmlScriptString);
        if (rtplatform == RUNTIME_PLATFORM.HADOOP || rtplatform == RUNTIME_PLATFORM.HYBRID) {
            String hadoop_home = System.getenv("HADOOP_HOME");
            LOG.info("HADOOP_HOME: " + hadoop_home);
        }
    }

    private static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private static void cleanSystemMLWorkspace() {
        try {
            String localtmp;
            DMLConfig conf = DMLConfig.readConfigurationFile(null);
            CleanupMR.runJob(conf);
            String scratch = conf.getTextValue("sysml.scratch");
            if (scratch != null) {
                MapReduceTool.deleteFileIfExistOnHDFS(scratch);
            }
            if ((localtmp = conf.getTextValue("sysml.localtmpdir")) != null) {
                LocalFileUtils.cleanupRcWorkingDirectory(localtmp);
            }
        }
        catch (Exception ex) {
            throw new DMLException("Failed to run SystemML workspace cleanup.", ex);
        }
    }

    public static enum EvictionPolicy {
        LRU,
        LFU,
        MIN_EVICT,
        MRU,
        ALIGN_MEMORY;

    }

    public static enum RUNTIME_PLATFORM {
        HADOOP,
        SINGLE_NODE,
        HYBRID,
        HYBRID_SPARK,
        SPARK;

    }
}

