/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JobClient
extends CLI {
    @InterfaceAudience.Private
    public static final String MAPREDUCE_CLIENT_RETRY_POLICY_ENABLED_KEY = "mapreduce.jobclient.retry.policy.enabled";
    @InterfaceAudience.Private
    public static final boolean MAPREDUCE_CLIENT_RETRY_POLICY_ENABLED_DEFAULT = false;
    @InterfaceAudience.Private
    public static final String MAPREDUCE_CLIENT_RETRY_POLICY_SPEC_KEY = "mapreduce.jobclient.retry.policy.spec";
    @InterfaceAudience.Private
    public static final String MAPREDUCE_CLIENT_RETRY_POLICY_SPEC_DEFAULT = "10000,6,60000,10";
    private TaskStatusFilter taskOutputFilter = TaskStatusFilter.FAILED;
    UserGroupInformation clientUgi;
    private static final TaskReport[] EMPTY_TASK_REPORTS;

    public JobClient() {
    }

    public JobClient(JobConf conf) throws IOException {
        this.init(conf);
    }

    public JobClient(Configuration conf) throws IOException {
        this.init(new JobConf(conf));
    }

    public void init(JobConf conf) throws IOException {
        this.setConf(conf);
        this.cluster = new Cluster(conf);
        this.clientUgi = UserGroupInformation.getCurrentUser();
    }

    public JobClient(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.cluster = new Cluster(jobTrackAddr, conf);
        this.clientUgi = UserGroupInformation.getCurrentUser();
    }

    public synchronized void close() throws IOException {
        this.cluster.close();
    }

    public synchronized FileSystem getFs() throws IOException {
        try {
            return this.cluster.getFileSystem();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Cluster getClusterHandle() {
        return this.cluster;
    }

    public RunningJob submitJob(String jobFile) throws FileNotFoundException, InvalidJobConfException, IOException {
        JobConf job = new JobConf(jobFile);
        return this.submitJob(job);
    }

    public RunningJob submitJob(JobConf conf) throws FileNotFoundException, IOException {
        return this.submitJobInternal(conf);
    }

    @InterfaceAudience.Private
    public RunningJob submitJobInternal(JobConf conf) throws FileNotFoundException, IOException {
        try {
            conf.setBooleanIfUnset("mapred.mapper.new-api", false);
            conf.setBooleanIfUnset("mapred.reducer.new-api", false);
            Job job = (Job)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
            this.cluster = job.getCluster();
            return new NetworkedJob(job);
        }
        catch (InterruptedException ie) {
            throw new IOException("interrupted", ie);
        }
    }

    private Job getJobUsingCluster(JobID jobid) throws IOException, InterruptedException {
        return (Job)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
    }

    public RunningJob getJob(JobID jobid) throws IOException {
        try {
            org.apache.hadoop.mapred.JobStatus status;
            Job job = this.getJobUsingCluster(jobid);
            if (job != null && (status = org.apache.hadoop.mapred.JobStatus.downgrade(job.getStatus())) != null) {
                return new NetworkedJob(status, this.cluster, new JobConf(job.getConfiguration()), null);
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        return null;
    }

    @Deprecated
    public RunningJob getJob(String jobid) throws IOException {
        return this.getJob(JobID.forName((String)jobid));
    }

    public TaskReport[] getMapTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.MAP);
    }

    private TaskReport[] getTaskReports(JobID jobId, TaskType type) throws IOException {
        try {
            Job j = this.getJobUsingCluster(jobId);
            if (j == null) {
                return EMPTY_TASK_REPORTS;
            }
            return TaskReport.downgradeArray(j.getTaskReports(type));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @Deprecated
    public TaskReport[] getMapTaskReports(String jobId) throws IOException {
        return this.getMapTaskReports(JobID.forName((String)jobId));
    }

    public TaskReport[] getReduceTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.REDUCE);
    }

    public TaskReport[] getCleanupTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.JOB_CLEANUP);
    }

    public TaskReport[] getSetupTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.JOB_SETUP);
    }

    @Deprecated
    public TaskReport[] getReduceTaskReports(String jobId) throws IOException {
        return this.getReduceTaskReports(JobID.forName((String)jobId));
    }

    public void displayTasks(JobID jobId, String type, String state) throws IOException {
        try {
            Job job = this.getJobUsingCluster(jobId);
            super.displayTasks(job, type, state);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public ClusterStatus getClusterStatus() throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<ClusterStatus>(){

                @Override
                public ClusterStatus run() throws IOException, InterruptedException {
                    ClusterMetrics metrics = JobClient.this.cluster.getClusterStatus();
                    return new ClusterStatus(metrics.getTaskTrackerCount(), metrics.getBlackListedTaskTrackerCount(), JobClient.this.cluster.getTaskTrackerExpiryInterval(), metrics.getOccupiedMapSlots(), metrics.getOccupiedReduceSlots(), metrics.getMapSlotCapacity(), metrics.getReduceSlotCapacity(), JobClient.this.cluster.getJobTrackerStatus(), metrics.getDecommissionedTaskTrackerCount(), metrics.getGrayListedTaskTrackerCount());
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private Collection<String> arrayToStringList(TaskTrackerInfo[] objs) {
        ArrayList<String> list = new ArrayList<String>();
        for (TaskTrackerInfo info : objs) {
            list.add(info.getTaskTrackerName());
        }
        return list;
    }

    private Collection<ClusterStatus.BlackListInfo> arrayToBlackListInfo(TaskTrackerInfo[] objs) {
        ArrayList<ClusterStatus.BlackListInfo> list = new ArrayList<ClusterStatus.BlackListInfo>();
        for (TaskTrackerInfo info : objs) {
            ClusterStatus.BlackListInfo binfo = new ClusterStatus.BlackListInfo();
            binfo.setTrackerName(info.getTaskTrackerName());
            binfo.setReasonForBlackListing(info.getReasonForBlacklist());
            binfo.setBlackListReport(info.getBlacklistReport());
            list.add(binfo);
        }
        return list;
    }

    public ClusterStatus getClusterStatus(boolean detailed) throws IOException {
        try {
            return (ClusterStatus)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public org.apache.hadoop.mapred.JobStatus[] jobsToComplete() throws IOException {
        ArrayList<org.apache.hadoop.mapred.JobStatus> stats = new ArrayList<org.apache.hadoop.mapred.JobStatus>();
        for (org.apache.hadoop.mapred.JobStatus stat : this.getAllJobs()) {
            if (stat.isJobComplete()) continue;
            stats.add(stat);
        }
        return stats.toArray(new org.apache.hadoop.mapred.JobStatus[0]);
    }

    public org.apache.hadoop.mapred.JobStatus[] getAllJobs() throws IOException {
        try {
            JobStatus[] jobs = (JobStatus[])this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
            org.apache.hadoop.mapred.JobStatus[] stats = new org.apache.hadoop.mapred.JobStatus[jobs.length];
            for (int i = 0; i < jobs.length; ++i) {
                stats[i] = org.apache.hadoop.mapred.JobStatus.downgrade(jobs[i]);
            }
            return stats;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        JobClient jc = new JobClient(job);
        RunningJob rj = jc.submitJob(job);
        try {
            if (!jc.monitorAndPrintJob(job, rj)) {
                throw new IOException("Job failed!");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return rj;
    }

    public boolean monitorAndPrintJob(JobConf conf, RunningJob job) throws IOException, InterruptedException {
        return ((NetworkedJob)job).monitorAndPrintJob();
    }

    static String getTaskLogURL(TaskAttemptID taskId, String baseUrl) {
        return baseUrl + "/tasklog?plaintext=true&attemptid=" + taskId;
    }

    static Configuration getConfiguration(String jobTrackerSpec) {
        Configuration conf = new Configuration();
        if (jobTrackerSpec != null) {
            if (jobTrackerSpec.indexOf(":") >= 0) {
                conf.set("mapred.job.tracker", jobTrackerSpec);
            } else {
                String classpathFile = "hadoop-" + jobTrackerSpec + ".xml";
                URL validate = conf.getResource(classpathFile);
                if (validate == null) {
                    throw new RuntimeException(classpathFile + " not found on CLASSPATH");
                }
                conf.addResource(classpathFile);
            }
        }
        return conf;
    }

    @Deprecated
    public void setTaskOutputFilter(TaskStatusFilter newValue) {
        this.taskOutputFilter = newValue;
    }

    public static TaskStatusFilter getTaskOutputFilter(JobConf job) {
        return TaskStatusFilter.valueOf(job.get("jobclient.output.filter", "FAILED"));
    }

    public static void setTaskOutputFilter(JobConf job, TaskStatusFilter newValue) {
        job.set("jobclient.output.filter", newValue.toString());
    }

    @Deprecated
    public TaskStatusFilter getTaskOutputFilter() {
        return this.taskOutputFilter;
    }

    @Override
    protected long getCounter(Counters cntrs, String counterGroupName, String counterName) throws IOException {
        org.apache.hadoop.mapred.Counters counters = org.apache.hadoop.mapred.Counters.downgrade(cntrs);
        return counters.findCounter(counterGroupName, counterName).getValue();
    }

    public int getDefaultMaps() throws IOException {
        try {
            return (Integer)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public int getDefaultReduces() throws IOException {
        try {
            return (Integer)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Path getSystemDir() {
        try {
            return (Path)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException ioe) {
            return null;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    public static boolean isJobDirValid(Path jobDirPath, FileSystem fs) throws IOException {
        FileStatus[] contents = fs.listStatus(jobDirPath);
        int matchCount = 0;
        if (contents != null && contents.length >= 2) {
            for (FileStatus status : contents) {
                if ("job.xml".equals(status.getPath().getName())) {
                    ++matchCount;
                }
                if (!"job.split".equals(status.getPath().getName())) continue;
                ++matchCount;
            }
            if (matchCount == 2) {
                return true;
            }
        }
        return false;
    }

    public Path getStagingAreaDir() throws IOException {
        try {
            return (Path)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private JobQueueInfo getJobQueueInfo(QueueInfo queue) {
        JobQueueInfo ret = new JobQueueInfo(queue);
        if (queue.getQueueChildren().size() > 0) {
            ArrayList<JobQueueInfo> childQueues = new ArrayList<JobQueueInfo>(queue.getQueueChildren().size());
            for (QueueInfo child : queue.getQueueChildren()) {
                childQueues.add(this.getJobQueueInfo(child));
            }
            ret.setChildren(childQueues);
        }
        return ret;
    }

    private JobQueueInfo[] getJobQueueInfoArray(QueueInfo[] queues) throws IOException {
        JobQueueInfo[] ret = new JobQueueInfo[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            ret[i] = this.getJobQueueInfo(queues[i]);
        }
        return ret;
    }

    public JobQueueInfo[] getRootQueues() throws IOException {
        try {
            return (JobQueueInfo[])this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo[] getChildQueues(String queueName) throws IOException {
        try {
            return (JobQueueInfo[])this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo[] getQueues() throws IOException {
        try {
            return (JobQueueInfo[])this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public org.apache.hadoop.mapred.JobStatus[] getJobsFromQueue(String queueName) throws IOException {
        try {
            QueueInfo queue = (QueueInfo)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
            if (queue == null) {
                return null;
            }
            JobStatus[] stats = queue.getJobStatuses();
            org.apache.hadoop.mapred.JobStatus[] ret = new org.apache.hadoop.mapred.JobStatus[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                ret[i] = org.apache.hadoop.mapred.JobStatus.downgrade(stats[i]);
            }
            return ret;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo getQueueInfo(String queueName) throws IOException {
        try {
            QueueInfo queueInfo = (QueueInfo)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
            if (queueInfo != null) {
                return new JobQueueInfo(queueInfo);
            }
            return null;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        try {
            org.apache.hadoop.mapreduce.QueueAclsInfo[] acls = (org.apache.hadoop.mapreduce.QueueAclsInfo[])this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
            QueueAclsInfo[] ret = new QueueAclsInfo[acls.length];
            for (int i = 0; i < acls.length; ++i) {
                ret[i] = QueueAclsInfo.downgrade((org.apache.hadoop.mapreduce.QueueAclsInfo)acls[i]);
            }
            return ret;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return (Token)this.clientUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        return token.renew(this.getConf());
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        token.cancel(this.getConf());
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new JobClient(), (String[])argv);
        System.exit(res);
    }

    static /* synthetic */ Cluster access$000(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$500(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$600(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Collection access$700(JobClient x0, TaskTrackerInfo[] x1) {
        return x0.arrayToStringList(x1);
    }

    static /* synthetic */ Cluster access$800(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Collection access$900(JobClient x0, TaskTrackerInfo[] x1) {
        return x0.arrayToBlackListInfo(x1);
    }

    static /* synthetic */ Cluster access$1000(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$1100(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$1200(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$1300(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$1400(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$1500(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$1600(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$1700(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ JobQueueInfo[] access$1800(JobClient x0, QueueInfo[] x1) throws IOException {
        return x0.getJobQueueInfoArray(x1);
    }

    static /* synthetic */ Cluster access$1900(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$2000(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$2100(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$2200(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$2300(JobClient x0) {
        return x0.cluster;
    }

    static /* synthetic */ Cluster access$2400(JobClient x0) {
        return x0.cluster;
    }

    static {
        ConfigUtil.loadResources();
        EMPTY_TASK_REPORTS = new TaskReport[0];
    }

    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }
}

