/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.io.serializer.WritableSerialization;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class WritableSerialization
extends Configured
implements Serialization<Writable> {
    @Override
    @InterfaceAudience.Private
    public boolean accept(Class<?> c) {
        return Writable.class.isAssignableFrom(c);
    }

    @Override
    @InterfaceAudience.Private
    public Serializer<Writable> getSerializer(Class<Writable> c) {
        return new WritableSerializer();
    }

    @Override
    @InterfaceAudience.Private
    public Deserializer<Writable> getDeserializer(Class<Writable> c) {
        return new WritableDeserializer(this.getConf(), c);
    }

    static class WritableSerializer
    extends Configured
    implements Serializer<Writable> {
        private DataOutputStream dataOut;

        WritableSerializer() {
        }

        @Override
        public void open(OutputStream out) {
            this.dataOut = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        }

        @Override
        public void serialize(Writable w) throws IOException {
            w.write(this.dataOut);
        }

        @Override
        public void close() throws IOException {
            this.dataOut.close();
        }
    }
}

