/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FadvisedChunkedFile;
import org.apache.hadoop.mapred.FadvisedFileRegion;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.proto.ShuffleHandlerRecoveryProtos;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleHeader;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.Options;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.CharsetUtil;

public class ShuffleHandler
extends AuxiliaryService {
    private static final Log LOG = LogFactory.getLog(ShuffleHandler.class);
    public static final String SHUFFLE_MANAGE_OS_CACHE = "mapreduce.shuffle.manage.os.cache";
    public static final boolean DEFAULT_SHUFFLE_MANAGE_OS_CACHE = true;
    public static final String SHUFFLE_READAHEAD_BYTES = "mapreduce.shuffle.readahead.bytes";
    public static final int DEFAULT_SHUFFLE_READAHEAD_BYTES = 0x400000;
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private static final String STATE_DB_NAME = "mapreduce_shuffle_state";
    private static final String STATE_DB_SCHEMA_VERSION_KEY = "shuffle-schema-version";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)0);
    private int port;
    private ChannelFactory selector;
    private final ChannelGroup accepted = new DefaultChannelGroup();
    protected HttpPipelineFactory pipelineFact;
    private int sslFileBufferSize;
    private boolean manageOsCache;
    private int readaheadLength;
    private int maxShuffleConnections;
    private int shuffleBufferSize;
    private boolean shuffleTransferToAllowed;
    private ReadaheadPool readaheadPool = ReadaheadPool.getInstance();
    private Map<String, String> userRsrc;
    private JobTokenSecretManager secretManager;
    private DB stateDb = null;
    public static final String MAPREDUCE_SHUFFLE_SERVICEID = "mapreduce_shuffle";
    public static final String SHUFFLE_PORT_CONFIG_KEY = "mapreduce.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 13562;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = "mapreduce.shuffle.connection-keep-alive.enable";
    public static final boolean DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = false;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = "mapreduce.shuffle.connection-keep-alive.timeout";
    public static final int DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = 5;
    public static final String SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = "mapreduce.shuffle.mapoutput-info.meta.cache.size";
    public static final int DEFAULT_SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = 1000;
    public static final String CONNECTION_CLOSE = "close";
    public static final String SUFFLE_SSL_FILE_BUFFER_SIZE_KEY = "mapreduce.shuffle.ssl.file.buffer.size";
    public static final int DEFAULT_SUFFLE_SSL_FILE_BUFFER_SIZE = 61440;
    public static final String MAX_SHUFFLE_CONNECTIONS = "mapreduce.shuffle.max.connections";
    public static final int DEFAULT_MAX_SHUFFLE_CONNECTIONS = 0;
    public static final String MAX_SHUFFLE_THREADS = "mapreduce.shuffle.max.threads";
    public static final int DEFAULT_MAX_SHUFFLE_THREADS = 0;
    public static final String SHUFFLE_BUFFER_SIZE = "mapreduce.shuffle.transfer.buffer.size";
    public static final int DEFAULT_SHUFFLE_BUFFER_SIZE = 131072;
    public static final String SHUFFLE_TRANSFERTO_ALLOWED = "mapreduce.shuffle.transferTo.allowed";
    public static final boolean DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = true;
    public static final boolean WINDOWS_DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = false;
    boolean connectionKeepAliveEnabled = false;
    int connectionKeepAliveTimeOut;
    int mapOutputMetaInfoCacheSize;
    final ShuffleMetrics metrics;

    ShuffleHandler(MetricsSystem ms) {
        super("httpshuffle");
        this.metrics = (ShuffleMetrics)ms.register((Object)new ShuffleMetrics());
    }

    public ShuffleHandler() {
        this(DefaultMetricsSystem.instance());
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(port);
        return ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public void initializeApplication(ApplicationInitializationContext context) {
        String user = context.getUser();
        ApplicationId appId = context.getApplicationId();
        ByteBuffer secret = context.getApplicationDataForService();
        try {
            Token<JobTokenIdentifier> jt = ShuffleHandler.deserializeServiceData(secret);
            JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
            this.recordJobShuffleInfo(jobId, user, jt);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during initApp", (Throwable)e);
        }
    }

    public void stopApplication(ApplicationTerminationContext context) {
        ApplicationId appId = context.getApplicationId();
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        try {
            this.removeJobShuffleInfo(jobId);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during stopApp", (Throwable)e);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.manageOsCache = conf.getBoolean(SHUFFLE_MANAGE_OS_CACHE, true);
        this.readaheadLength = conf.getInt(SHUFFLE_READAHEAD_BYTES, 0x400000);
        this.maxShuffleConnections = conf.getInt(MAX_SHUFFLE_CONNECTIONS, 0);
        int maxShuffleThreads = conf.getInt(MAX_SHUFFLE_THREADS, 0);
        if (maxShuffleThreads == 0) {
            maxShuffleThreads = 2 * Runtime.getRuntime().availableProcessors();
        }
        this.shuffleBufferSize = conf.getInt(SHUFFLE_BUFFER_SIZE, 131072);
        this.shuffleTransferToAllowed = conf.getBoolean(SHUFFLE_TRANSFERTO_ALLOWED, !Shell.WINDOWS);
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.selector = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory), maxShuffleThreads);
        super.serviceInit(new Configuration(conf));
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        this.userRsrc = new ConcurrentHashMap<String, String>();
        this.secretManager = new JobTokenSecretManager();
        this.recoverState(conf);
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        try {
            this.pipelineFact = new HttpPipelineFactory(conf);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFact);
        this.port = conf.getInt(SHUFFLE_PORT_CONFIG_KEY, 13562);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.getLocalAddress()).getPort();
        conf.set(SHUFFLE_PORT_CONFIG_KEY, Integer.toString(this.port));
        this.pipelineFact.SHUFFLE.setPort(this.port);
        LOG.info((Object)(this.getName() + " listening on port " + this.port));
        super.serviceStart();
        this.sslFileBufferSize = conf.getInt(SUFFLE_SSL_FILE_BUFFER_SIZE_KEY, 61440);
        this.connectionKeepAliveEnabled = conf.getBoolean(SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED, false);
        this.connectionKeepAliveTimeOut = Math.max(1, conf.getInt(SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT, 5));
        this.mapOutputMetaInfoCacheSize = Math.max(1, conf.getInt(SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE, 1000));
    }

    protected void serviceStop() throws Exception {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        if (this.selector != null) {
            ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
            bootstrap.releaseExternalResources();
        }
        if (this.pipelineFact != null) {
            this.pipelineFact.destroy();
        }
        if (this.stateDb != null) {
            this.stateDb.close();
        }
        super.serviceStop();
    }

    public synchronized ByteBuffer getMetaData() {
        try {
            return ShuffleHandler.serializeMetaData(this.port);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during getMeta", (Throwable)e);
            return null;
        }
    }

    protected Shuffle getShuffle(Configuration conf) {
        return new Shuffle(conf);
    }

    private void recoverState(Configuration conf) throws IOException {
        Path recoveryRoot = this.getRecoveryPath();
        if (recoveryRoot != null) {
            this.startStore(recoveryRoot);
            Pattern jobPattern = Pattern.compile("job_[0-9]+_[0-9]+");
            LeveldbIterator iter = null;
            try {
                iter = new LeveldbIterator(this.stateDb);
                iter.seek(JniDBFactory.bytes((String)"job"));
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                    if (!jobPattern.matcher(key).matches()) {
                        break;
                    }
                    this.recoverJobShuffleInfo(key, (byte[])entry.getValue());
                }
            }
            catch (DBException e) {
                throw new IOException("Database error during recovery", e);
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
    }

    private void startStore(Path recoveryRoot) throws IOException {
        Options options = new Options();
        options.createIfMissing(false);
        options.logger((Logger)new LevelDBLogger());
        Path dbPath = new Path(recoveryRoot, STATE_DB_NAME);
        LOG.info((Object)("Using state database at " + dbPath + " for recovery"));
        File dbfile = new File(dbPath.toString());
        try {
            this.stateDb = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info((Object)("Creating state database at " + dbfile));
                options.createIfMissing(true);
                try {
                    this.stateDb = JniDBFactory.factory.open(dbfile, options);
                    this.storeVersion();
                }
                catch (DBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            throw e;
        }
        this.checkVersion();
    }

    @VisibleForTesting
    Version loadVersion() throws IOException {
        byte[] data = this.stateDb.get(JniDBFactory.bytes((String)STATE_DB_SCHEMA_VERSION_KEY));
        if (data == null || data.length == 0) {
            return Version.newInstance((int)1, (int)0);
        }
        VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        return version;
    }

    private void storeSchemaVersion(Version version) throws IOException {
        String key = STATE_DB_SCHEMA_VERSION_KEY;
        byte[] data = ((VersionPBImpl)version).getProto().toByteArray();
        try {
            this.stateDb.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void storeVersion() throws IOException {
        this.storeSchemaVersion(CURRENT_VERSION_INFO);
    }

    @VisibleForTesting
    void storeVersion(Version version) throws IOException {
        this.storeSchemaVersion(version);
    }

    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info((Object)("Loaded state DB schema version info " + loadedVersion));
        if (loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new IOException("Incompatible version for state DB schema: expecting DB schema version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info((Object)("Storing state DB schedma version info " + this.getCurrentVersion()));
        this.storeVersion();
    }

    private void addJobToken(JobID jobId, String user, Token<JobTokenIdentifier> jobToken) {
        this.userRsrc.put(jobId.toString(), user);
        this.secretManager.addTokenForJob(jobId.toString(), jobToken);
        LOG.info((Object)("Added token for " + jobId.toString()));
    }

    private void recoverJobShuffleInfo(String jobIdStr, byte[] data) throws IOException {
        JobID jobId;
        try {
            jobId = JobID.forName((String)jobIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Bad job ID " + jobIdStr + " in state store", e);
        }
        ShuffleHandlerRecoveryProtos.JobShuffleInfoProto proto = ShuffleHandlerRecoveryProtos.JobShuffleInfoProto.parseFrom(data);
        String user = proto.getUser();
        SecurityProtos.TokenProto tokenProto = proto.getJobToken();
        Token jobToken = new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
        this.addJobToken(jobId, user, (Token<JobTokenIdentifier>)jobToken);
    }

    private void recordJobShuffleInfo(JobID jobId, String user, Token<JobTokenIdentifier> jobToken) throws IOException {
        if (this.stateDb != null) {
            SecurityProtos.TokenProto tokenProto = SecurityProtos.TokenProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])jobToken.getIdentifier())).setPassword(ByteString.copyFrom((byte[])jobToken.getPassword())).setKind(jobToken.getKind().toString()).setService(jobToken.getService().toString()).build();
            ShuffleHandlerRecoveryProtos.JobShuffleInfoProto proto = ShuffleHandlerRecoveryProtos.JobShuffleInfoProto.newBuilder().setUser(user).setJobToken(tokenProto).build();
            try {
                this.stateDb.put(JniDBFactory.bytes((String)jobId.toString()), proto.toByteArray());
            }
            catch (DBException e) {
                throw new IOException("Error storing " + jobId, e);
            }
        }
        this.addJobToken(jobId, user, jobToken);
    }

    private void removeJobShuffleInfo(JobID jobId) throws IOException {
        String jobIdStr = jobId.toString();
        this.secretManager.removeTokenForJob(jobIdStr);
        this.userRsrc.remove(jobIdStr);
        if (this.stateDb != null) {
            try {
                this.stateDb.delete(JniDBFactory.bytes((String)jobIdStr));
            }
            catch (DBException e) {
                throw new IOException("Unable to remove " + jobId + " from state store", e);
            }
        }
    }

    class Shuffle
    extends SimpleChannelUpstreamHandler {
        private final Configuration conf;
        private final IndexCache indexCache;
        private final LocalDirAllocator lDirAlloc = new LocalDirAllocator("yarn.nodemanager.local-dirs");
        private int port;

        public Shuffle(Configuration conf) {
            this.conf = conf;
            this.indexCache = new IndexCache(new JobConf(conf));
            this.port = conf.getInt(ShuffleHandler.SHUFFLE_PORT_CONFIG_KEY, 13562);
        }

        public void setPort(int port) {
            this.port = port;
        }

        private List<String> splitMaps(List<String> mapq) {
            if (null == mapq) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : mapq) {
                Collections.addAll(ret, s.split(","));
            }
            return ret;
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
            if (ShuffleHandler.this.maxShuffleConnections > 0 && ShuffleHandler.this.accepted.size() >= ShuffleHandler.this.maxShuffleConnections) {
                LOG.info((Object)String.format("Current number of shuffle connections (%d) is greater than or equal to the max allowed shuffle connections (%d)", ShuffleHandler.this.accepted.size(), ShuffleHandler.this.maxShuffleConnections));
                evt.getChannel().close();
                return;
            }
            ShuffleHandler.this.accepted.add((Object)evt.getChannel());
            super.channelOpen(ctx, evt);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
            String jobId;
            int reduceId;
            HttpRequest request = (HttpRequest)evt.getMessage();
            if (request.getMethod() != HttpMethod.GET) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            if (!"mapreduce".equals(request.getHeader("name")) || !"1.0.0".equals(request.getHeader("version"))) {
                this.sendError(ctx, "Incompatible shuffle request version", HttpResponseStatus.BAD_REQUEST);
            }
            Map q = new QueryStringDecoder(request.getUri()).getParameters();
            List keepAliveList = (List)q.get("keepAlive");
            boolean keepAliveParam = false;
            if (keepAliveList != null && keepAliveList.size() == 1) {
                keepAliveParam = Boolean.valueOf((String)keepAliveList.get(0));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("KeepAliveParam : " + keepAliveList + " : " + keepAliveParam));
                }
            }
            List<String> mapIds = this.splitMaps((List)q.get("map"));
            List reduceQ = (List)q.get("reduce");
            List jobQ = (List)q.get("job");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RECV: " + request.getUri() + "\n  mapId: " + mapIds + "\n  reduceId: " + reduceQ + "\n  jobId: " + jobQ + "\n  keepAlive: " + keepAliveParam));
            }
            if (mapIds == null || reduceQ == null || jobQ == null) {
                this.sendError(ctx, "Required param job, map and reduce", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (reduceQ.size() != 1 || jobQ.size() != 1) {
                this.sendError(ctx, "Too many job/reduce parameters", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                reduceId = Integer.parseInt((String)reduceQ.get(0));
                jobId = (String)jobQ.get(0);
            }
            catch (NumberFormatException e) {
                this.sendError(ctx, "Bad reduce parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            catch (IllegalArgumentException e) {
                this.sendError(ctx, "Bad job parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            String reqUri = request.getUri();
            if (null == reqUri) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            try {
                this.verifyRequest(jobId, ctx, request, (HttpResponse)response, new URL("http", "", this.port, reqUri));
            }
            catch (IOException e) {
                LOG.warn((Object)"Shuffle failure ", (Throwable)e);
                this.sendError(ctx, e.getMessage(), HttpResponseStatus.UNAUTHORIZED);
                return;
            }
            HashMap<String, MapOutputInfo> mapOutputInfoMap = new HashMap<String, MapOutputInfo>();
            Channel ch = evt.getChannel();
            String user = (String)ShuffleHandler.this.userRsrc.get(jobId);
            String outputBasePathStr = this.getBaseLocation(jobId, user);
            try {
                this.populateHeaders(mapIds, outputBasePathStr, user, reduceId, request, (HttpResponse)response, keepAliveParam, mapOutputInfoMap);
            }
            catch (IOException e) {
                ch.write((Object)response);
                LOG.error((Object)"Shuffle error in populating headers :", (Throwable)e);
                String errorMessage = this.getErrorMessage(e);
                this.sendError(ctx, errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            ch.write((Object)response);
            ChannelFuture lastMap = null;
            for (String mapId : mapIds) {
                try {
                    MapOutputInfo info = (MapOutputInfo)mapOutputInfoMap.get(mapId);
                    if (info == null) {
                        info = this.getMapOutputInfo(outputBasePathStr, mapId, reduceId, user);
                    }
                    if (null != (lastMap = this.sendMapOutput(ctx, ch, user, mapId, reduceId, info))) continue;
                    this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                catch (IOException e) {
                    LOG.error((Object)"Shuffle error :", (Throwable)e);
                    String errorMessage = this.getErrorMessage(e);
                    this.sendError(ctx, errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            lastMap.addListener((ChannelFutureListener)ShuffleHandler.this.metrics);
            lastMap.addListener(ChannelFutureListener.CLOSE);
        }

        private String getErrorMessage(Throwable t) {
            StringBuffer sb = new StringBuffer(t.getMessage());
            while (t.getCause() != null) {
                sb.append(t.getCause().getMessage());
                t = t.getCause();
            }
            return sb.toString();
        }

        private String getBaseLocation(String jobId, String user) {
            JobID jobID = JobID.forName((String)jobId);
            ApplicationId appID = ApplicationId.newInstance((long)Long.parseLong(jobID.getJtIdentifier()), (int)jobID.getId());
            String baseStr = "usercache/" + user + "/" + "appcache" + "/" + ConverterUtils.toString((ApplicationId)appID) + "/output" + "/";
            return baseStr;
        }

        protected MapOutputInfo getMapOutputInfo(String base, String mapId, int reduce, String user) throws IOException {
            Path indexFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out.index", this.conf);
            IndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, indexFileName, user);
            Path mapOutputFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out", this.conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(base + " : " + mapOutputFileName + " : " + indexFileName));
            }
            MapOutputInfo outputInfo = new MapOutputInfo(mapOutputFileName, info);
            return outputInfo;
        }

        protected void populateHeaders(List<String> mapIds, String outputBaseStr, String user, int reduce, HttpRequest request, HttpResponse response, boolean keepAliveParam, Map<String, MapOutputInfo> mapOutputInfoMap) throws IOException {
            long contentLength = 0L;
            for (String mapId : mapIds) {
                String base = outputBaseStr + mapId;
                MapOutputInfo outputInfo = this.getMapOutputInfo(base, mapId, reduce, user);
                if (mapOutputInfoMap.size() < ShuffleHandler.this.mapOutputMetaInfoCacheSize) {
                    mapOutputInfoMap.put(mapId, outputInfo);
                }
                Path indexFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out.index", this.conf);
                IndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, indexFileName, user);
                ShuffleHeader header = new ShuffleHeader(mapId, info.partLength, info.rawLength, reduce);
                DataOutputBuffer dob = new DataOutputBuffer();
                header.write((DataOutput)dob);
                contentLength += info.partLength;
                contentLength += (long)dob.getLength();
            }
            this.setResponseHeaders(response, keepAliveParam, contentLength);
        }

        protected void setResponseHeaders(HttpResponse response, boolean keepAliveParam, long contentLength) {
            if (!ShuffleHandler.this.connectionKeepAliveEnabled && !keepAliveParam) {
                LOG.info((Object)"Setting connection close header...");
                response.setHeader("Connection", (Object)ShuffleHandler.CONNECTION_CLOSE);
            } else {
                response.setHeader("Content-Length", (Object)String.valueOf(contentLength));
                response.setHeader("Connection", (Object)"Keep-Alive");
                response.setHeader("Keep-Alive", (Object)("timeout=" + ShuffleHandler.this.connectionKeepAliveTimeOut));
                LOG.info((Object)("Content Length in shuffle : " + contentLength));
            }
        }

        protected void verifyRequest(String appid, ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, URL requestUri) throws IOException {
            SecretKey tokenSecret = ShuffleHandler.this.secretManager.retrieveTokenSecret(appid);
            if (null == tokenSecret) {
                LOG.info((Object)("Request for unknown token " + appid));
                throw new IOException("could not find jobid");
            }
            String enc_str = SecureShuffleUtils.buildMsgFrom((URL)requestUri);
            String urlHashStr = request.getHeader("UrlHash");
            if (urlHashStr == null) {
                LOG.info((Object)("Missing header hash for " + appid));
                throw new IOException("fetcher cannot be authenticated");
            }
            if (LOG.isDebugEnabled()) {
                int len = urlHashStr.length();
                LOG.debug((Object)("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1)));
            }
            SecureShuffleUtils.verifyReply((String)urlHashStr, (String)enc_str, (SecretKey)tokenSecret);
            String reply = SecureShuffleUtils.generateHash((byte[])urlHashStr.getBytes(Charsets.UTF_8), (SecretKey)tokenSecret);
            response.setHeader("ReplyHash", (Object)reply);
            response.setHeader("name", (Object)"mapreduce");
            response.setHeader("version", (Object)"1.0.0");
            if (LOG.isDebugEnabled()) {
                int len = reply.length();
                LOG.debug((Object)("Fetcher request verfied. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1)));
            }
        }

        protected ChannelFuture sendMapOutput(ChannelHandlerContext ctx, Channel ch, String user, String mapId, int reduce, MapOutputInfo mapOutputInfo) throws IOException {
            ChannelFuture writeFuture;
            RandomAccessFile spill;
            IndexRecord info = mapOutputInfo.indexRecord;
            ShuffleHeader header = new ShuffleHeader(mapId, info.partLength, info.rawLength, reduce);
            DataOutputBuffer dob = new DataOutputBuffer();
            header.write((DataOutput)dob);
            ch.write((Object)ChannelBuffers.wrappedBuffer((byte[])dob.getData(), (int)0, (int)dob.getLength()));
            File spillfile = new File(mapOutputInfo.mapOutputFileName.toString());
            try {
                spill = SecureIOUtils.openForRandomRead((File)spillfile, (String)"r", (String)user, null);
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)(spillfile + " not found"));
                return null;
            }
            if (ch.getPipeline().get(SslHandler.class) == null) {
                final FadvisedFileRegion partition = new FadvisedFileRegion(spill, info.startOffset, info.partLength, ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath(), ShuffleHandler.this.shuffleBufferSize, ShuffleHandler.this.shuffleTransferToAllowed);
                writeFuture = ch.write((Object)partition);
                writeFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            partition.transferSuccessful();
                        }
                        partition.releaseExternalResources();
                    }
                });
            } else {
                FadvisedChunkedFile chunk = new FadvisedChunkedFile(spill, info.startOffset, info.partLength, ShuffleHandler.this.sslFileBufferSize, ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath());
                writeFuture = ch.write((Object)chunk);
            }
            ShuffleHandler.this.metrics.shuffleConnections.incr();
            ShuffleHandler.this.metrics.shuffleOutputBytes.incr(info.partLength);
            return writeFuture;
        }

        protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            this.sendError(ctx, "", status);
        }

        protected void sendError(ChannelHandlerContext ctx, String message, HttpResponseStatus status) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
            response.setHeader("name", (Object)"mapreduce");
            response.setHeader("version", (Object)"1.0.0");
            response.setContent(ChannelBuffers.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8));
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channel ch = e.getChannel();
            Throwable cause = e.getCause();
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (cause instanceof IOException) {
                if (cause instanceof ClosedChannelException) {
                    LOG.debug((Object)"Ignoring closed channel error", cause);
                    return;
                }
                String message = String.valueOf(cause.getMessage());
                if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                    LOG.debug((Object)"Ignoring client socket close", cause);
                    return;
                }
            }
            LOG.error((Object)"Shuffle error: ", cause);
            if (ch.isConnected()) {
                LOG.error((Object)("Shuffle error " + e));
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }

        class MapOutputInfo {
            final Path mapOutputFileName;
            final IndexRecord indexRecord;

            MapOutputInfo(Path mapOutputFileName, IndexRecord indexRecord) {
                this.mapOutputFileName = mapOutputFileName;
                this.indexRecord = indexRecord;
            }
        }
    }

    class HttpPipelineFactory
    implements ChannelPipelineFactory {
        final Shuffle SHUFFLE;
        private SSLFactory sslFactory;

        public HttpPipelineFactory(Configuration conf) throws Exception {
            this.SHUFFLE = ShuffleHandler.this.getShuffle(conf);
            if (conf.getBoolean("mapreduce.shuffle.ssl.enabled", false)) {
                LOG.info((Object)"Encrypted shuffle is enabled.");
                this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
                this.sslFactory.init();
            }
        }

        public void destroy() {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
            }
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            if (this.sslFactory != null) {
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.sslFactory.createSSLEngine()));
            }
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("chunking", (ChannelHandler)new ChunkedWriteHandler());
            pipeline.addLast("shuffle", (ChannelHandler)this.SHUFFLE);
            return pipeline;
        }
    }

    private static class LevelDBLogger
    implements Logger {
        private static final Log LOG = LogFactory.getLog(LevelDBLogger.class);

        private LevelDBLogger() {
        }

        public void log(String message) {
            LOG.info((Object)message);
        }
    }

    @Metrics(about="Shuffle output metrics", context="mapred")
    static class ShuffleMetrics
    implements ChannelFutureListener {
        @Metric(value={"Shuffle output in bytes"})
        MutableCounterLong shuffleOutputBytes;
        @Metric(value={"# of failed shuffle outputs"})
        MutableCounterInt shuffleOutputsFailed;
        @Metric(value={"# of succeeeded shuffle outputs"})
        MutableCounterInt shuffleOutputsOK;
        @Metric(value={"# of current shuffle connections"})
        MutableGaugeInt shuffleConnections;

        ShuffleMetrics() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.shuffleOutputsOK.incr();
            } else {
                this.shuffleOutputsFailed.incr();
            }
            this.shuffleConnections.decr();
        }
    }
}

