/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.NLineInputFormat;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForColocatedFileSplit;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class RemoteParForColocatedNLineInputFormat
extends NLineInputFormat {
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        InputSplit[] tmp = super.getSplits(job, numSplits);
        MatrixCharacteristics mc = MRJobConfiguration.getPartitionedMatrixSize(job);
        ParForProgramBlock.PDataPartitionFormat dpf = MRJobConfiguration.getPartitioningFormat(job);
        ParForProgramBlock.PartitionFormat pf = new ParForProgramBlock.PartitionFormat(dpf, -1);
        int blen = (int)(pf.isRowwise() ? pf.getNumRows(mc) : pf.getNumColumns(mc));
        String fname = MRJobConfiguration.getPartitioningFilename(job);
        InputSplit[] ret = new InputSplit[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            ret[i] = tmp[i] instanceof FileSplit ? new RemoteParForColocatedFileSplit((FileSplit)tmp[i], fname, blen) : tmp[i];
        }
        return ret;
    }
}

