/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import org.apache.avro.ipc.stats.FakeTicks;
import org.apache.avro.ipc.stats.Stopwatch;
import org.junit.Assert;
import org.junit.Test;

public class TestStopwatch {
    @Test
    public void testNormal() {
        FakeTicks f = new FakeTicks();
        Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
        f.passTime(10L);
        s.start();
        f.passTime(20L);
        Assert.assertEquals((long)20L, (long)s.elapsedNanos());
        f.passTime(40L);
        s.stop();
        f.passTime(80L);
        Assert.assertEquals((long)60L, (long)s.elapsedNanos());
    }

    @Test(expected=IllegalStateException.class)
    public void testNotStarted1() {
        FakeTicks f = new FakeTicks();
        Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
        s.elapsedNanos();
    }

    @Test(expected=IllegalStateException.class)
    public void testNotStarted2() {
        FakeTicks f = new FakeTicks();
        Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
        s.stop();
    }

    @Test(expected=IllegalStateException.class)
    public void testTwiceStarted() {
        FakeTicks f = new FakeTicks();
        Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
        s.start();
        s.start();
    }

    @Test(expected=IllegalStateException.class)
    public void testTwiceStopped() {
        FakeTicks f = new FakeTicks();
        Stopwatch s = new Stopwatch((Stopwatch.Ticks)f);
        s.start();
        s.stop();
        s.stop();
    }

    @Test
    public void testSystemStopwatch() {
        Stopwatch s = new Stopwatch(Stopwatch.SYSTEM_TICKS);
        s.start();
        s.stop();
        Assert.assertTrue((s.elapsedNanos() >= 0L ? 1 : 0) != 0);
    }
}

