/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf;

import java.io.IOException;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.io.MatrixReaderFactory;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.udf.FunctionParameter;

public class Matrix
extends FunctionParameter {
    private static final long serialVersionUID = -1058329938431848909L;
    public static final String DEFAULT_FILENAME = "ext_funct";
    private String _filePath;
    private long _rows;
    private long _cols;
    private ValueType _vType;
    private MatrixObject _mo;

    public Matrix(long rows, long cols, ValueType vType) {
        this(DEFAULT_FILENAME, rows, cols, vType);
    }

    public Matrix(String path, long rows, long cols, ValueType vType) {
        super(FunctionParameter.FunctionParameterType.Matrix);
        this._filePath = path;
        this._rows = rows;
        this._cols = cols;
        this._vType = vType;
    }

    public Matrix(MatrixObject mo, ValueType vType) {
        super(FunctionParameter.FunctionParameterType.Matrix);
        this._filePath = mo.getFileName();
        this._rows = mo.getNumRows();
        this._cols = mo.getNumColumns();
        this._vType = vType;
        this._mo = mo;
    }

    public void setMatrixObject(MatrixObject mo) {
        this._mo = mo;
    }

    public MatrixObject getMatrixObject() {
        return this._mo;
    }

    public String getFilePath() {
        return this._filePath;
    }

    public long getNumRows() {
        return this._rows;
    }

    public long getNumCols() {
        return this._cols;
    }

    public ValueType getValueType() {
        return this._vType;
    }

    public double[][] getMatrixAsDoubleArray() throws DMLRuntimeException, IOException {
        double[][] ret = null;
        if (this._mo != null) {
            MatrixBlock mb = (MatrixBlock)this._mo.acquireRead();
            ret = DataConverter.convertToDoubleMatrix(mb);
            this._mo.release();
        } else {
            MatrixReader reader = MatrixReaderFactory.createMatrixReader(InputInfo.TextCellInputInfo);
            MatrixBlock mb = reader.readMatrixFromHDFS(this.getFilePath(), this._rows, this._cols, -1, -1, -1L);
            ret = DataConverter.convertToDoubleMatrix(mb);
        }
        return ret;
    }

    public void setMatrixDoubleArray(double[][] data) throws IOException, DMLRuntimeException {
        MatrixBlock mb = DataConverter.convertToMatrixBlock(data);
        this.setMatrixDoubleArray(mb, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
    }

    public void setMatrixDoubleArray(double[] data) throws IOException, DMLRuntimeException {
        MatrixBlock mb = DataConverter.convertToMatrixBlock(data, true);
        this.setMatrixDoubleArray(mb, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
    }

    public void setMatrixDoubleArray(MatrixBlock mb, OutputInfo oinfo, InputInfo iinfo) throws IOException {
        this._rows = mb.getNumRows();
        this._cols = mb.getNumColumns();
        long nnz = mb.getNonZeros();
        int rblen = ConfigurationManager.getBlocksize();
        int cblen = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(this._rows, this._cols, rblen, cblen, nnz);
        MetaDataFormat mfmd = new MetaDataFormat(mc, oinfo, iinfo);
        try {
            if (mb.getInMemorySize() < 0x800000L) {
                mb.examSparsity();
            }
            this._mo = new MatrixObject(Expression.ValueType.DOUBLE, this._filePath, mfmd);
            this._mo.acquireModify(mb);
            this._mo.release();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static enum ValueType {
        Double,
        Integer;

    }
}

