/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import jcuda.Pointer;
import jcuda.jcublas.JCublas2;
import jcuda.jcublas.cublasHandle;
import jcuda.jcusolver.JCusolverDn;
import jcuda.jcusolver.cusolverDnHandle;
import jcuda.jcusparse.JCusparse;
import jcuda.jcusparse.cusparseHandle;
import jcuda.jcusparse.cusparseMatDescr;
import jcuda.runtime.JCuda;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.matrix.data.CudaSupportFunctions;
import org.apache.sysml.utils.GPUStatistics;

public class DoublePrecisionCudaSupportFunctions
implements CudaSupportFunctions {
    private static final Log LOG = LogFactory.getLog((String)DoublePrecisionCudaSupportFunctions.class.getName());

    @Override
    public int cusparsecsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse.cusparseDcsrgemm((cusparseHandle)handle, (int)transA, (int)transB, (int)m, (int)n, (int)k, (cusparseMatDescr)descrA, (int)nnzA, (Pointer)csrValA, (Pointer)csrRowPtrA, (Pointer)csrColIndA, (cusparseMatDescr)descrB, (int)nnzB, (Pointer)csrValB, (Pointer)csrRowPtrB, (Pointer)csrColIndB, (cusparseMatDescr)descrC, (Pointer)csrValC, (Pointer)csrRowPtrC, (Pointer)csrColIndC);
    }

    @Override
    public int cublasgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.cublasDgeam((cublasHandle)handle, (int)transa, (int)transb, (int)m, (int)n, (Pointer)alpha, (Pointer)A, (int)lda, (Pointer)beta, (Pointer)B, (int)ldb, (Pointer)C, (int)ldc);
    }

    @Override
    public int cusparsecsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.cusparseDcsrmv((cusparseHandle)handle, (int)transA, (int)m, (int)n, (int)nnz, (Pointer)alpha, (cusparseMatDescr)descrA, (Pointer)csrValA, (Pointer)csrRowPtrA, (Pointer)csrColIndA, (Pointer)x, (Pointer)beta, (Pointer)y);
    }

    @Override
    public int cusparsecsrmm2(cusparseHandle handle, int transa, int transb, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.cusparseDcsrmm2((cusparseHandle)handle, (int)transa, (int)transb, (int)m, (int)n, (int)k, (int)nnz, (Pointer)alpha, (cusparseMatDescr)descrA, (Pointer)csrValA, (Pointer)csrRowPtrA, (Pointer)csrColIndA, (Pointer)B, (int)ldb, (Pointer)beta, (Pointer)C, (int)ldc);
    }

    @Override
    public int cublasdot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.cublasDdot((cublasHandle)handle, (int)n, (Pointer)x, (int)incx, (Pointer)y, (int)incy, (Pointer)result);
    }

    @Override
    public int cublasgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.cublasDgemv((cublasHandle)handle, (int)trans, (int)m, (int)n, (Pointer)alpha, (Pointer)A, (int)lda, (Pointer)x, (int)incx, (Pointer)beta, (Pointer)y, (int)incy);
    }

    @Override
    public int cublasgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.cublasDgemm((cublasHandle)handle, (int)transa, (int)transb, (int)m, (int)n, (int)k, (Pointer)alpha, (Pointer)A, (int)lda, (Pointer)B, (int)ldb, (Pointer)beta, (Pointer)C, (int)ldc);
    }

    @Override
    public int cusparsecsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse.cusparseDcsr2csc((cusparseHandle)handle, (int)m, (int)n, (int)nnz, (Pointer)csrVal, (Pointer)csrRowPtr, (Pointer)csrColInd, (Pointer)cscVal, (Pointer)cscRowInd, (Pointer)cscColPtr, (int)copyValues, (int)idxBase);
    }

    @Override
    public int cublassyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.cublasDsyrk((cublasHandle)handle, (int)uplo, (int)trans, (int)n, (int)k, (Pointer)alpha, (Pointer)A, (int)lda, (Pointer)beta, (Pointer)C, (int)ldc);
    }

    @Override
    public int cublasaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.cublasDaxpy((cublasHandle)handle, (int)n, (Pointer)alpha, (Pointer)x, (int)incx, (Pointer)y, (int)incy);
    }

    @Override
    public int cublastrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.cublasDtrsm((cublasHandle)handle, (int)side, (int)uplo, (int)trans, (int)diag, (int)m, (int)n, (Pointer)alpha, (Pointer)A, (int)lda, (Pointer)B, (int)ldb);
    }

    @Override
    public int cusolverDngeqrf_bufferSize(cusolverDnHandle handle, int m, int n, Pointer A, int lda, int[] Lwork) {
        return JCusolverDn.cusolverDnDgeqrf_bufferSize((cusolverDnHandle)handle, (int)m, (int)n, (Pointer)A, (int)lda, (int[])Lwork);
    }

    @Override
    public int cusolverDngeqrf(cusolverDnHandle handle, int m, int n, Pointer A, int lda, Pointer TAU, Pointer Workspace, int Lwork, Pointer devInfo) {
        return JCusolverDn.cusolverDnDgeqrf((cusolverDnHandle)handle, (int)m, (int)n, (Pointer)A, (int)lda, (Pointer)TAU, (Pointer)Workspace, (int)Lwork, (Pointer)devInfo);
    }

    @Override
    public int cusolverDnormqr(cusolverDnHandle handle, int side, int trans, int m, int n, int k, Pointer A, int lda, Pointer tau, Pointer C, int ldc, Pointer work, int lwork, Pointer devInfo) {
        return JCusolverDn.cusolverDnDormqr((cusolverDnHandle)handle, (int)side, (int)trans, (int)m, (int)n, (int)k, (Pointer)A, (int)lda, (Pointer)tau, (Pointer)C, (int)ldc, (Pointer)work, (int)lwork, (Pointer)devInfo);
    }

    @Override
    public int cusparsecsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse.cusparseDcsrgeam((cusparseHandle)handle, (int)m, (int)n, (Pointer)alpha, (cusparseMatDescr)descrA, (int)nnzA, (Pointer)csrValA, (Pointer)csrRowPtrA, (Pointer)csrColIndA, (Pointer)beta, (cusparseMatDescr)descrB, (int)nnzB, (Pointer)csrValB, (Pointer)csrRowPtrB, (Pointer)csrColIndB, (cusparseMatDescr)descrC, (Pointer)csrValC, (Pointer)csrRowPtrC, (Pointer)csrColIndC);
    }

    @Override
    public int cusparsecsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse.cusparseDcsr2dense((cusparseHandle)handle, (int)m, (int)n, (cusparseMatDescr)descrA, (Pointer)csrValA, (Pointer)csrRowPtrA, (Pointer)csrColIndA, (Pointer)A, (int)lda);
    }

    @Override
    public int cusparsedense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse.cusparseDdense2csr((cusparseHandle)handle, (int)m, (int)n, (cusparseMatDescr)descrA, (Pointer)A, (int)lda, (Pointer)nnzPerRow, (Pointer)csrValA, (Pointer)csrRowPtrA, (Pointer)csrColIndA);
    }

    @Override
    public int cusparsennz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.cusparseDnnz((cusparseHandle)handle, (int)dirA, (int)m, (int)n, (cusparseMatDescr)descrA, (Pointer)A, (int)lda, (Pointer)nnzPerRowCol, (Pointer)nnzTotalDevHostPtr);
    }

    @Override
    public void deviceToHost(GPUContext gCtx, Pointer src, double[] dest, String instName, boolean isEviction) throws DMLRuntimeException {
        long t1;
        long l = t1 = DMLScript.FINEGRAINED_STATISTICS && instName != null ? System.nanoTime() : 0L;
        if (src == null) {
            throw new DMLRuntimeException("The source pointer in deviceToHost is null");
        }
        if (dest == null) {
            throw new DMLRuntimeException("The destination array in deviceToHost is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deviceToHost: src of size " + gCtx.getMemoryManager().getSizeAllocatedGPUPointer(src) + " (in bytes) -> dest of size " + dest.length * 8 + " (in bytes)."));
        }
        JCuda.cudaMemcpy((Pointer)Pointer.to((double[])dest), (Pointer)src, (long)((long)dest.length * 8L), (int)2);
        if (DMLScript.FINEGRAINED_STATISTICS && instName != null) {
            GPUStatistics.maintainCPMiscTimes(instName, "D2H", System.nanoTime() - t1);
        }
    }

    @Override
    public void hostToDevice(GPUContext gCtx, double[] src, Pointer dest, String instName) throws DMLRuntimeException {
        long t1 = DMLScript.FINEGRAINED_STATISTICS && instName != null ? System.nanoTime() : 0L;
        JCuda.cudaMemcpy((Pointer)dest, (Pointer)Pointer.to((double[])src), (long)((long)src.length * 8L), (int)1);
        if (DMLScript.FINEGRAINED_STATISTICS && instName != null) {
            GPUStatistics.maintainCPMiscTimes(instName, "H2D", System.nanoTime() - t1);
        }
    }
}

