/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.Serializable;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.ConvolutionUtils;

public class ConvolutionParameters
implements Serializable {
    private static final long serialVersionUID = -212362627205772829L;
    public int N;
    public int C;
    public int H;
    public int W;
    public int K;
    public int R;
    public int S;
    public int P;
    public int Q;
    public int stride_h;
    public int stride_w;
    public int pad_h;
    public int pad_w;
    public int numThreads;
    public boolean enableNative = false;
    public MatrixBlock input1;
    public MatrixBlock input2;
    public MatrixBlock output;
    public MatrixBlock bias;
    public int[] start_indexes_h;
    public int[] end_indexes_h;
    public int[] start_indexes_w;
    public int[] end_indexes_w;
    public double minValForMaxPoolOperations = -1.7976931348623157E308;

    public ConvolutionParameters(long N, long C, long H, long W, long K, long R, long S, long stride_h, long stride_w, long pad_h, long pad_w, int numThreads) throws DMLRuntimeException {
        this.N = ConvolutionParameters.convertToInt(N);
        this.C = ConvolutionParameters.convertToInt(C);
        this.H = ConvolutionParameters.convertToInt(H);
        this.W = ConvolutionParameters.convertToInt(W);
        this.K = ConvolutionParameters.convertToInt(K);
        this.R = ConvolutionParameters.convertToInt(R);
        this.S = ConvolutionParameters.convertToInt(S);
        this.stride_h = ConvolutionParameters.convertToInt(stride_h);
        this.stride_w = ConvolutionParameters.convertToInt(stride_w);
        this.pad_h = ConvolutionParameters.convertToInt(pad_h);
        this.pad_w = ConvolutionParameters.convertToInt(pad_w);
        this.P = H >= 0L && pad_h >= 0L && R >= 0L && stride_h >= 0L ? (int)((H + 2L * pad_h - R) / stride_h + 1L) : -1;
        this.Q = W >= 0L && pad_w >= 0L && S >= 0L && stride_w >= 0L ? (int)((W + 2L * pad_w - S) / stride_w + 1L) : -1;
        this.numThreads = numThreads;
    }

    public ConvolutionParameters(int N, int C, int H, int W, int K, int R, int S, int stride_h, int stride_w, int pad_h, int pad_w, int numThreads) {
        this.N = N;
        this.C = C;
        this.H = H;
        this.W = W;
        this.K = K;
        this.R = R;
        this.S = S;
        this.stride_h = stride_h;
        this.stride_w = stride_w;
        this.pad_h = pad_h;
        this.pad_w = pad_w;
        this.P = H <= 0 || R <= 0 || stride_h < 0 || pad_h < 0 ? -1 : (int)ConvolutionUtils.getP(H, R, stride_h, pad_h);
        this.Q = W <= 0 || S <= 0 || stride_w < 0 || pad_w < 0 ? -1 : (int)ConvolutionUtils.getQ(W, S, stride_w, pad_w);
        this.numThreads = numThreads;
    }

    private static int convertToInt(long val) throws DMLRuntimeException {
        if (val > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("The value for ConvolutionParameters is too large:" + val);
        }
        return (int)val;
    }

    public boolean compare(ConvolutionParameters that) {
        return this.N == that.N && this.C == that.C && this.H == that.H && this.W == that.W && this.K == that.K && this.R == that.R && this.S == that.S && this.stride_h == that.stride_h && this.stride_w == that.stride_w && this.pad_h == that.pad_h && this.pad_w == that.pad_w && this.numThreads == that.numThreads;
    }

    public String toString() {
        return "(NCHW=[" + this.N + " " + this.C + " " + this.H + " " + this.W + "], KCRS=[" + this.K + " " + this.R + " " + this.S + "], stride=[" + this.stride_h + "," + this.stride_w + "], pad=[" + this.pad_h + "," + this.pad_w + "])";
    }

    public void setIfUnknown(Hop N, Hop C, Hop H, Hop W, Hop K, Hop R, Hop S, Hop stride_h, Hop stride_w, Hop pad_h, Hop pad_w, int numThreads) throws DMLRuntimeException {
        if (this.N < 0) {
            this.N = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(N));
        }
        if (this.C < 0) {
            this.C = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(C));
        }
        if (this.H < 0) {
            this.H = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(H));
        }
        if (this.W < 0) {
            this.W = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(W));
        }
        if (this.K < 0) {
            this.K = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(K));
        }
        if (this.R < 0) {
            this.R = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(R));
        }
        if (this.S < 0) {
            this.S = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(S));
        }
        if (this.stride_h < 0) {
            this.stride_h = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(stride_h));
        }
        if (this.stride_w < 0) {
            this.stride_w = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(stride_w));
        }
        if (this.pad_h < 0) {
            this.pad_h = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(pad_h));
        }
        if (this.pad_w < 0) {
            this.pad_w = ConvolutionParameters.convertToInt(Hop.computeSizeInformation(pad_w));
        }
        if (this.P < 0 && this.H >= 0 && this.R >= 0 && this.stride_h >= 0 && this.pad_h >= 0) {
            this.P = (int)ConvolutionUtils.getP(this.H, this.R, this.stride_h, this.pad_h);
        }
        if (this.Q < 0 && this.W >= 0 && this.S >= 0 && this.stride_w >= 0 && this.pad_w >= 0) {
            this.Q = (int)ConvolutionUtils.getQ(this.W, this.S, this.stride_w, this.pad_w);
        }
        this.numThreads = numThreads;
    }

    public boolean isOutputThreadSafe() {
        return this.output.isThreadSafe();
    }

    public boolean isStride1Pad0() {
        return this.stride_h == 1 && this.stride_w == 1 && this.pad_h == 0 && this.pad_w == 0;
    }

    public boolean isAllOnes(Integer ... params) {
        boolean ret = true;
        Integer[] integerArray = params;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int param = integerArray[i];
            ret &= param == 1;
        }
        return ret;
    }
}

