/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.BinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class RemoveEmptyMRInstruction
extends BinaryInstruction {
    private final long _len;
    private final boolean _rmRows;
    private final boolean _emptyRet;

    private RemoveEmptyMRInstruction(Operator op, byte in1, byte in2, long len, boolean rmRows, boolean emptyRet, byte out, String istr) {
        super(MRInstruction.MRType.RemoveEmpty, op, in1, in2, out, istr);
        this.instString = istr;
        this._len = len;
        this._rmRows = rmRows;
        this._emptyRet = emptyRet;
    }

    public boolean isRemoveRows() {
        return this._rmRows;
    }

    public boolean isEmptyReturn() {
        return this._emptyRet;
    }

    public long getOutputLen() {
        return this._len;
    }

    public static RemoveEmptyMRInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 6);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("rmempty")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an RemoveEmptyMRInstruction: " + str);
        }
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        long rlen = UtilFunctions.toLong(Double.parseDouble(parts[3]));
        boolean rmRows = parts[4].equals("rows");
        boolean emptyRet = Boolean.parseBoolean(parts[5].toLowerCase());
        byte out = Byte.parseByte(parts[6]);
        return new RemoveEmptyMRInstruction(null, in1, in2, rlen, rmRows, emptyRet, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        IndexedMatrixValue inData = cachedValues.getFirst(this.input1);
        IndexedMatrixValue inOffset = cachedValues.getFirst(this.input2);
        MatrixIndexes ix = inData.getIndexes();
        MatrixValue mb = inData.getValue();
        if (this._len > 0L) {
            ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
            LibMatrixReorg.rmempty(inData, inOffset, this._rmRows, this._len, blockRowFactor, blockColFactor, out);
            for (IndexedMatrixValue imv : out) {
                cachedValues.add(this.output, imv);
            }
        } else {
            int n = this._emptyRet ? 1 : 0;
            cachedValues.add(this.output, new IndexedMatrixValue(new MatrixIndexes(this._rmRows ? 1L : ix.getRowIndex(), this._rmRows ? ix.getColumnIndex() : 1L), new MatrixBlock(this._rmRows ? n : mb.getNumRows(), this._rmRows ? mb.getNumColumns() : n, false)));
        }
    }
}

