/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.PMMJ;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.IDistributedCacheConsumer;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.DistributedCacheInput;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRBaseForCommonInstructions;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class PMMJMRInstruction
extends BinaryMRInstructionBase
implements IDistributedCacheConsumer {
    private long _rlen = -1L;
    private boolean _outputEmptyBlocks = true;

    private PMMJMRInstruction(Operator op, byte in1, byte in2, byte out, long nrow, PMMJ.CacheType ctype, boolean outputEmpty, String istr) {
        super(MRInstruction.MRType.PMMJ, op, in1, in2, out);
        this.instString = istr;
        this._rlen = nrow;
        this._outputEmptyBlocks = outputEmpty;
    }

    public long getNumRows() {
        return this._rlen;
    }

    public boolean getOutputEmptyBlocks() {
        return this._outputEmptyBlocks;
    }

    public static PMMJMRInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 6);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        long nrow = UtilFunctions.toLong(Double.parseDouble(parts[3]));
        byte out = Byte.parseByte(parts[4]);
        PMMJ.CacheType ctype = PMMJ.CacheType.valueOf(parts[5]);
        boolean outputEmpty = Boolean.parseBoolean(parts[6]);
        if (!opcode.equalsIgnoreCase("pmm")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an PmmMRInstruction: " + str);
        }
        return new PMMJMRInstruction(new Operator(true), in1, in2, out, nrow, ctype, outputEmpty, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        long maxPos;
        long rowIX2;
        boolean multipleOuts;
        DistributedCacheInput dcInput = MRBaseForCommonInstructions.dcValues.get(this.input1);
        IndexedMatrixValue in2 = cachedValues.getFirst(this.input2);
        IndexedMatrixValue in1 = dcInput.getDataBlock((int)in2.getIndexes().getRowIndex(), 1);
        MatrixBlock mb1 = (MatrixBlock)in1.getValue();
        MatrixBlock mb2 = (MatrixBlock)in2.getValue();
        long minPos = UtilFunctions.toLong(mb1.minNonZero());
        long rowIX1 = (minPos - 1L) / (long)blockRowFactor + 1L;
        boolean bl = multipleOuts = rowIX1 != (rowIX2 = ((maxPos = UtilFunctions.toLong(mb1.max())) - 1L) / (long)blockRowFactor + 1L);
        if (minPos >= 1L) {
            double spmb1 = OptimizerUtils.getSparsity(mb1.getNumRows(), 1L, mb1.getNonZeros());
            long estnnz = (long)(spmb1 * (double)mb2.getNonZeros());
            boolean sparse = MatrixBlock.evalSparseFormatInMemory(blockRowFactor, mb2.getNumColumns(), estnnz);
            IndexedMatrixValue out1 = cachedValues.holdPlace(this.output, valueClass);
            IndexedMatrixValue out2 = multipleOuts ? cachedValues.holdPlace(this.output, valueClass) : null;
            out1.getValue().reset(blockRowFactor, mb2.getNumColumns(), sparse);
            if (out2 != null) {
                out2.getValue().reset(UtilFunctions.computeBlockSize(this._rlen, rowIX2, blockRowFactor), mb2.getNumColumns(), sparse);
            }
            mb1.permutationMatrixMultOperations(mb2, out1.getValue(), out2 != null ? out2.getValue() : null);
            ((MatrixBlock)out1.getValue()).setNumRows(UtilFunctions.computeBlockSize(this._rlen, rowIX1, blockRowFactor));
            out1.getIndexes().setIndexes(rowIX1, in2.getIndexes().getColumnIndex());
            if (out2 != null) {
                out2.getIndexes().setIndexes(rowIX2, in2.getIndexes().getColumnIndex());
            }
            if (!this._outputEmptyBlocks && out1.getValue().isEmpty() && (out2 == null || out2.getValue().isEmpty())) {
                cachedValues.remove(this.output);
            }
        }
    }

    @Override
    public boolean isDistCacheOnlyIndex(String inst, byte index) {
        return index == this.input1 && index != this.input2;
    }

    @Override
    public void addDistCacheIndex(String inst, ArrayList<Byte> indexes) {
        indexes.add(this.input1);
    }
}

