/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.TernaryOperator;

public class TernaryCPInstruction
extends ComputationCPInstruction {
    private TernaryCPInstruction(TernaryOperator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String str) {
        super(CPInstruction.CPType.Ternary, op, in1, in2, in3, out, opcode, str);
    }

    public static TernaryCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand operand1 = new CPOperand(parts[1]);
        CPOperand operand2 = new CPOperand(parts[2]);
        CPOperand operand3 = new CPOperand(parts[3]);
        CPOperand outOperand = new CPOperand(parts[4]);
        TernaryOperator op = InstructionUtils.parseTernaryOperator(opcode);
        return new TernaryCPInstruction(op, operand1, operand2, operand3, outOperand, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        if (this.input1.isMatrix() || this.input2.isMatrix() || this.input3.isMatrix()) {
            MatrixBlock m1 = this.input1.isMatrix() ? ec.getMatrixInput(this.input1.getName()) : new MatrixBlock(ec.getScalarInput(this.input1).getDoubleValue());
            MatrixBlock m2 = this.input2.isMatrix() ? ec.getMatrixInput(this.input2.getName()) : new MatrixBlock(ec.getScalarInput(this.input2).getDoubleValue());
            MatrixBlock m3 = this.input3.isMatrix() ? ec.getMatrixInput(this.input3.getName()) : new MatrixBlock(ec.getScalarInput(this.input3).getDoubleValue());
            MatrixBlock out = m1.ternaryOperations((TernaryOperator)this._optr, m2, m3, new MatrixBlock());
            if (this.input1.isMatrix()) {
                ec.releaseMatrixInput(this.input1.getName());
            }
            if (this.input2.isMatrix()) {
                ec.releaseMatrixInput(this.input2.getName());
            }
            if (this.input3.isMatrix()) {
                ec.releaseMatrixInput(this.input3.getName());
            }
            ec.setMatrixOutput(this.output.getName(), out);
        } else {
            double value = ((TernaryOperator)this._optr).fn.execute(ec.getScalarInput(this.input1).getDoubleValue(), ec.getScalarInput(this.input2).getDoubleValue(), ec.getScalarInput(this.input3).getDoubleValue());
            ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.createScalarObject(this.output.getValueType(), value));
        }
    }
}

