/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.ParameterizedBuiltin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;
import org.apache.sysml.runtime.transform.decode.Decoder;
import org.apache.sysml.runtime.transform.decode.DecoderFactory;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.encode.EncoderFactory;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.DataConverter;

public class ParameterizedBuiltinCPInstruction
extends ComputationCPInstruction {
    private static final int TOSTRING_MAXROWS = 100;
    private static final int TOSTRING_MAXCOLS = 100;
    private static final int TOSTRING_DECIMAL = 3;
    private static final boolean TOSTRING_SPARSE = false;
    private static final String TOSTRING_SEPARATOR = " ";
    private static final String TOSTRING_LINESEPARATOR = "\n";
    protected final HashMap<String, String> params;

    protected ParameterizedBuiltinCPInstruction(Operator op, HashMap<String, String> paramsMap, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.ParameterizedBuiltin, op, null, null, out, opcode, istr);
        this.params = paramsMap;
    }

    public HashMap<String, String> getParameterMap() {
        return this.params;
    }

    public String getParam(String key) {
        return this.getParameterMap().get(key);
    }

    public static HashMap<String, String> constructParameterMap(String[] params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 1; i <= params.length - 2; ++i) {
            String[] parts = params[i].split("=");
            paramMap.put(parts[0], parts[1]);
        }
        return paramMap;
    }

    public static ParameterizedBuiltinCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand out = new CPOperand(parts[parts.length - 1]);
        HashMap<String, String> paramsMap = ParameterizedBuiltinCPInstruction.constructParameterMap(parts);
        ParameterizedBuiltin func = null;
        if (opcode.equalsIgnoreCase("cdf")) {
            if (paramsMap.get("dist") == null) {
                throw new DMLRuntimeException("Invalid distribution: " + str);
            }
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode, paramsMap.get("dist"));
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("invcdf")) {
            if (paramsMap.get("dist") == null) {
                throw new DMLRuntimeException("Invalid distribution: " + str);
            }
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode, paramsMap.get("dist"));
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("groupedagg")) {
            String fnStr = paramsMap.get("fn");
            if (fnStr == null) {
                throw new DMLRuntimeException("Function parameter is missing in groupedAggregate.");
            }
            if (fnStr.equalsIgnoreCase("centralmoment") && paramsMap.get("order") == null) {
                throw new DMLRuntimeException("Mandatory \"order\" must be specified when fn=\"centralmoment\" in groupedAggregate.");
            }
            Operator op = GroupedAggregateInstruction.parseGroupedAggOperator(fnStr, paramsMap.get("order"));
            return new ParameterizedBuiltinCPInstruction(op, paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rmempty") || opcode.equalsIgnoreCase("replace") || opcode.equalsIgnoreCase("rexpand")) {
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode);
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equals("transformapply") || opcode.equals("transformdecode") || opcode.equals("transformcolmap") || opcode.equals("transformmeta")) {
            return new ParameterizedBuiltinCPInstruction(null, paramsMap, out, opcode, str);
        }
        if (opcode.equals("toString")) {
            return new ParameterizedBuiltinCPInstruction(null, paramsMap, out, opcode, str);
        }
        throw new DMLRuntimeException("Unknown opcode (" + opcode + ") for ParameterizedBuiltin Instruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        DoubleObject sores = null;
        if (opcode.equalsIgnoreCase("cdf")) {
            SimpleOperator op = (SimpleOperator)this._optr;
            double result = op.fn.execute(this.params);
            sores = new DoubleObject(result);
            ec.setScalarOutput(this.output.getName(), sores);
        } else if (opcode.equalsIgnoreCase("invcdf")) {
            SimpleOperator op = (SimpleOperator)this._optr;
            double result = op.fn.execute(this.params);
            sores = new DoubleObject(result);
            ec.setScalarOutput(this.output.getName(), sores);
        } else if (opcode.equalsIgnoreCase("groupedagg")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            MatrixBlock groups = ec.getMatrixInput(this.params.get("groups"), this.getExtendedOpcode());
            MatrixBlock weights = null;
            if (this.params.get("weights") != null) {
                weights = ec.getMatrixInput(this.params.get("weights"), this.getExtendedOpcode());
            }
            int ngroups = -1;
            if (this.params.get("ngroups") != null) {
                ngroups = (int)Double.parseDouble(this.params.get("ngroups"));
            }
            int k = Integer.parseInt(this.params.get("k"));
            MatrixBlock soresBlock = groups.groupedAggOperations(target, weights, new MatrixBlock(), ngroups, this._optr, k);
            ec.setMatrixOutput(this.output.getName(), soresBlock, this.getExtendedOpcode());
            weights = null;
            groups = null;
            target = null;
            ec.releaseMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            ec.releaseMatrixInput(this.params.get("groups"), this.getExtendedOpcode());
            if (this.params.get("weights") != null) {
                ec.releaseMatrixInput(this.params.get("weights"), this.getExtendedOpcode());
            }
        } else if (opcode.equalsIgnoreCase("rmempty")) {
            String margin = this.params.get("margin");
            if (!margin.equals("rows") && !margin.equals("cols")) {
                throw new DMLRuntimeException("Unspupported margin identifier '" + margin + "'.");
            }
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            MatrixBlock select = this.params.containsKey("select") ? ec.getMatrixInput(this.params.get("select"), this.getExtendedOpcode()) : null;
            boolean emptyReturn = Boolean.parseBoolean(this.params.get("empty.return").toLowerCase());
            MatrixBlock soresBlock = target.removeEmptyOperations(new MatrixBlock(), margin.equals("rows"), emptyReturn, select);
            ec.setMatrixOutput(this.output.getName(), soresBlock, this.getExtendedOpcode());
            ec.releaseMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            if (this.params.containsKey("select")) {
                ec.releaseMatrixInput(this.params.get("select"), this.getExtendedOpcode());
            }
        } else if (opcode.equalsIgnoreCase("replace")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            double pattern = Double.parseDouble(this.params.get("pattern"));
            double replacement = Double.parseDouble(this.params.get("replacement"));
            MatrixBlock ret = (MatrixBlock)target.replaceOperations(new MatrixBlock(), pattern, replacement);
            ec.setMatrixOutput(this.output.getName(), ret, this.getExtendedOpcode());
            ec.releaseMatrixInput(this.params.get("target"), this.getExtendedOpcode());
        } else if (opcode.equalsIgnoreCase("rexpand")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            double maxVal = Double.parseDouble(this.params.get("max"));
            boolean dirVal = this.params.get("dir").equals("rows");
            boolean cast = Boolean.parseBoolean(this.params.get("cast"));
            boolean ignore = Boolean.parseBoolean(this.params.get("ignore"));
            int numThreads = Integer.parseInt(this.params.get("k"));
            MatrixBlock ret = target.rexpandOperations(new MatrixBlock(), maxVal, dirVal, cast, ignore, numThreads);
            ec.setMatrixOutput(this.output.getName(), ret, this.getExtendedOpcode());
            ec.releaseMatrixInput(this.params.get("target"), this.getExtendedOpcode());
        } else if (opcode.equalsIgnoreCase("transformapply")) {
            FrameBlock data = ec.getFrameInput(this.params.get("target"));
            FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
            String[] colNames = data.getColumnNames();
            Encoder encoder = EncoderFactory.createEncoder(this.params.get("spec"), colNames, data.getNumColumns(), meta);
            MatrixBlock mbout = encoder.apply(data, new MatrixBlock(data.getNumRows(), data.getNumColumns(), false));
            ec.setMatrixOutput(this.output.getName(), mbout, this.getExtendedOpcode());
            ec.releaseFrameInput(this.params.get("target"));
            ec.releaseFrameInput(this.params.get("meta"));
        } else if (opcode.equalsIgnoreCase("transformdecode")) {
            MatrixBlock data = ec.getMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
            String[] colnames = meta.getColumnNames();
            Decoder decoder = DecoderFactory.createDecoder(this.getParameterMap().get("spec"), colnames, null, meta);
            FrameBlock fbout = decoder.decode(data, new FrameBlock(decoder.getSchema()));
            fbout.setColumnNames(Arrays.copyOfRange(colnames, 0, fbout.getNumColumns()));
            ec.setFrameOutput(this.output.getName(), fbout);
            ec.releaseMatrixInput(this.params.get("target"), this.getExtendedOpcode());
            ec.releaseFrameInput(this.params.get("meta"));
        } else if (opcode.equalsIgnoreCase("transformcolmap")) {
            FrameBlock meta = ec.getFrameInput(this.params.get("target"));
            String[] colNames = meta.getColumnNames();
            Encoder encoder = EncoderFactory.createEncoder(this.params.get("spec"), colNames, meta.getNumColumns(), null);
            MatrixBlock mbout = encoder.getColMapping(meta, new MatrixBlock(meta.getNumColumns(), 3, false));
            ec.setMatrixOutput(this.output.getName(), mbout, this.getExtendedOpcode());
            ec.releaseFrameInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("transformmeta")) {
            String spec = this.getParameterMap().get("spec");
            String path = this.getParameterMap().get("transformPath");
            String delim = this.getParameterMap().containsKey("sep") ? this.getParameterMap().get("sep") : ",";
            FrameBlock meta = null;
            try {
                meta = TfMetaUtils.readTransformMetaDataFromFile(spec, path, delim);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
            ec.setFrameOutput(this.output.getName(), meta);
        } else if (opcode.equalsIgnoreCase("toString")) {
            int rows = this.getParam("rows") != null ? Integer.parseInt(this.getParam("rows")) : 100;
            int cols = this.getParam("cols") != null ? Integer.parseInt(this.getParam("cols")) : 100;
            int decimal = this.getParam("decimal") != null ? Integer.parseInt(this.getParam("decimal")) : 3;
            boolean sparse = this.getParam("sparse") != null ? Boolean.parseBoolean(this.getParam("sparse")) : false;
            String separator = this.getParam("sep") != null ? this.getParam("sep") : TOSTRING_SEPARATOR;
            String lineseparator = this.getParam("linesep") != null ? this.getParam("linesep") : TOSTRING_LINESEPARATOR;
            CacheableData<?> data = ec.getCacheableData(this.getParam("target"));
            String out = null;
            if (data instanceof MatrixObject) {
                MatrixBlock matrix = (MatrixBlock)data.acquireRead();
                this.warnOnTrunction(matrix, rows, cols);
                out = DataConverter.toString(matrix, sparse, separator, lineseparator, rows, cols, decimal);
            } else if (data instanceof FrameObject) {
                FrameBlock frame = (FrameBlock)data.acquireRead();
                this.warnOnTrunction(frame, rows, cols);
                out = DataConverter.toString(frame, sparse, separator, lineseparator, rows, cols, decimal);
            } else {
                throw new DMLRuntimeException("toString only converts matrix or frames to string");
            }
            ec.releaseCacheableData(this.getParam("target"));
            ec.setScalarOutput(this.output.getName(), new StringObject(out));
        } else {
            throw new DMLRuntimeException("Unknown opcode : " + opcode);
        }
    }

    private void warnOnTrunction(CacheBlock data, int rows, int cols) {
        if (this.getParam("rows") == null && data.getNumRows() > rows || this.getParam("cols") == null && data.getNumColumns() > cols) {
            LOG.warn((Object)("Truncating " + data.getClass().getSimpleName() + " of size " + data.getNumRows() + "x" + data.getNumColumns() + " to " + rows + "x" + cols + ". Use toString(X, rows=..., cols=...) if necessary."));
        }
    }
}

