/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.IndexRange;

public final class FrameIndexingCPInstruction
extends IndexingCPInstruction {
    protected FrameIndexingCPInstruction(Operator op, CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(op, in, rl, ru, cl, cu, out, opcode, istr);
    }

    protected FrameIndexingCPInstruction(Operator op, CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(op, lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec);
        if (opcode.equalsIgnoreCase("rightIndex")) {
            FrameBlock in = ec.getFrameInput(this.input1.getName());
            FrameBlock out = in.slice(ixrange, new FrameBlock());
            ec.releaseFrameInput(this.input1.getName());
            ec.setFrameOutput(this.output.getName(), out);
        } else if (opcode.equalsIgnoreCase("leftIndex")) {
            FrameBlock lin = ec.getFrameInput(this.input1.getName());
            FrameBlock out = null;
            if (this.input2.getDataType() == Expression.DataType.FRAME) {
                FrameBlock rin = ec.getFrameInput(this.input2.getName());
                out = lin.leftIndexingOperations(rin, ixrange, new FrameBlock());
                ec.releaseFrameInput(this.input2.getName());
            } else {
                if (!ixrange.isScalar()) {
                    throw new DMLRuntimeException("Invalid index range of scalar leftindexing: " + ixrange.toString() + ".");
                }
                ScalarObject scalar = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
                out = new FrameBlock(lin);
                out.set((int)ixrange.rowStart, (int)ixrange.colStart, scalar.getStringValue());
            }
            ec.releaseFrameInput(this.input1.getName());
            ec.setFrameOutput(this.output.getName(), out);
        } else {
            throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in FrameIndexingCPInstruction.");
        }
    }
}

