/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;

public class AggregateUnaryCPInstruction
extends UnaryCPInstruction {
    private final AUType _type;

    private AggregateUnaryCPInstruction(Operator op, CPOperand in, CPOperand out, AUType type, String opcode, String istr) {
        this(op, in, null, null, out, type, opcode, istr);
    }

    protected AggregateUnaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, AUType type, String opcode, String istr) {
        super(CPInstruction.CPType.AggregateUnary, op, in1, in2, in3, out, opcode, istr);
        this._type = type;
    }

    public static AggregateUnaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        if (opcode.equalsIgnoreCase("nrow") || opcode.equalsIgnoreCase("ncol") || opcode.equalsIgnoreCase("length")) {
            return new AggregateUnaryCPInstruction(new SimpleOperator(Builtin.getBuiltinFnObject(opcode)), in1, out, AUType.valueOf(opcode.toUpperCase()), opcode, str);
        }
        AggregateUnaryOperator aggun = InstructionUtils.parseBasicAggregateUnaryOperator(opcode, Integer.parseInt(parts[3]));
        return new AggregateUnaryCPInstruction(aggun, in1, out, AUType.DEFAULT, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String output_name = this.output.getName();
        String opcode = this.getOpcode();
        if (this._type.isMeta()) {
            if (!ec.getVariables().keySet().contains(this.input1.getName())) {
                throw new DMLRuntimeException("Variable '" + this.input1.getName() + "' does not exist.");
            }
            MatrixCharacteristics mc = ec.getMatrixCharacteristics(this.input1.getName());
            long rval = AggregateUnaryCPInstruction.getSizeMetaData(this._type, mc);
            if (!mc.dimsKnown()) {
                if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE || this.input1.getDataType() == Expression.DataType.FRAME && OptimizerUtils.isHadoopExecutionMode()) {
                    if (OptimizerUtils.isHadoopExecutionMode()) {
                        LOG.warn((Object)("Reading csv input frame of unkown size into memory for '" + opcode + "'."));
                    }
                    CacheableData<?> obj = ec.getCacheableData(this.input1.getName());
                    obj.acquireRead();
                    obj.refreshMetaData();
                    obj.release();
                    mc = ec.getMatrixCharacteristics(this.input1.getName());
                    rval = AggregateUnaryCPInstruction.getSizeMetaData(this._type, mc);
                } else {
                    throw new DMLRuntimeException("Invalid meta data returned by '" + opcode + "': " + rval + ":" + this.instString);
                }
            }
            ec.setScalarOutput(output_name, new IntObject(rval));
        } else {
            MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
            AggregateUnaryOperator au_op = (AggregateUnaryOperator)this._optr;
            MatrixBlock resultBlock = (MatrixBlock)matBlock.aggregateUnaryOperations(au_op, new MatrixBlock(), matBlock.getNumRows(), matBlock.getNumColumns(), new MatrixIndexes(1L, 1L), true);
            ec.releaseMatrixInput(this.input1.getName());
            if (this.output.getDataType() == Expression.DataType.SCALAR) {
                DoubleObject ret = new DoubleObject(resultBlock.getValue(0, 0));
                ec.setScalarOutput(output_name, ret);
            } else {
                ec.setMatrixOutput(output_name, resultBlock);
            }
        }
    }

    private static long getSizeMetaData(AUType type, MatrixCharacteristics mc) {
        switch (type) {
            case NROW: {
                return mc.getRows();
            }
            case NCOL: {
                return mc.getCols();
            }
            case LENGTH: {
                return mc.getRows() * mc.getCols();
            }
        }
        throw new RuntimeException("Opcode not applicable: " + type.name());
    }

    public static enum AUType {
        NROW,
        NCOL,
        LENGTH,
        DEFAULT;


        public boolean isMeta() {
            return this != DEFAULT;
        }
    }
}

