/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.ParForStatement;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTree;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreePlanMappingRuntime;
import org.apache.sysml.runtime.controlprogram.parfor.opt.Optimizer;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cpfile.MatrixIndexingCPFileInstruction;
import org.apache.sysml.runtime.instructions.cpfile.ParameterizedBuiltinCPFileInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;

public class OptTreeConverter {
    public static boolean INCLUDE_FUNCTIONS = true;
    private static OptTreePlanMappingAbstract _hlMap = null;
    private static OptTreePlanMappingRuntime _rtMap = null;

    public static OptTree createOptTree(int ck, double cm, Optimizer.PlanInputType type, ParForStatementBlock pfsb, ParForProgramBlock pfpb, ExecutionContext ec) throws DMLRuntimeException, HopsException {
        OptNode root = null;
        switch (type) {
            case ABSTRACT_PLAN: {
                _hlMap.putRootProgram(pfsb.getDMLProg(), pfpb.getProgram());
                HashSet<String> memo = new HashSet<String>();
                root = OptTreeConverter.rCreateAbstractOptNode(pfsb, pfpb, ec.getVariables(), true, memo);
                root.checkAndCleanupRecursiveFunc(new HashSet<String>());
                root.checkAndCleanupLeafNodes();
                break;
            }
            case RUNTIME_PLAN: {
                root = OptTreeConverter.rCreateOptNode(pfpb, ec.getVariables(), true, true);
                break;
            }
            default: {
                throw new DMLRuntimeException("Optimizer plan input type " + (Object)((Object)type) + " not supported.");
            }
        }
        OptTree tree = new OptTree(ck, cm, type, root);
        return tree;
    }

    public static OptTree createAbstractOptTree(int ck, double cm, ParForStatementBlock pfsb, ParForProgramBlock pfpb, Set<String> memo, ExecutionContext ec) throws DMLRuntimeException {
        OptTree tree = null;
        OptNode root = null;
        try {
            root = OptTreeConverter.rCreateAbstractOptNode(pfsb, pfpb, ec.getVariables(), true, memo);
            tree = new OptTree(ck, cm, root);
        }
        catch (HopsException he) {
            throw new DMLRuntimeException(he);
        }
        return tree;
    }

    public static OptNode rCreateOptNode(ProgramBlock pb, LocalVariableMap vars, boolean topLevel, boolean storeObjs) throws DMLRuntimeException {
        OptNode node = null;
        if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            node = new OptNode(OptNode.NodeType.IF);
            if (storeObjs) {
                _rtMap.putMapping(ipb, node);
            }
            node.setExecType(OptNode.ExecType.CP);
            OptNode ifn = new OptNode(OptNode.NodeType.GENERIC);
            node.addChilds(OptTreeConverter.createOptNodes(ipb.getPredicate(), vars, storeObjs));
            node.addChild(ifn);
            for (ProgramBlock lpb : ipb.getChildBlocksIfBody()) {
                ifn.addChild(OptTreeConverter.rCreateOptNode(lpb, vars, topLevel, storeObjs));
            }
            if (ipb.getChildBlocksElseBody() != null && ipb.getChildBlocksElseBody().size() > 0) {
                OptNode efn = new OptNode(OptNode.NodeType.GENERIC);
                node.addChild(efn);
                for (ProgramBlock lpb : ipb.getChildBlocksElseBody()) {
                    efn.addChild(OptTreeConverter.rCreateOptNode(lpb, vars, topLevel, storeObjs));
                }
            }
        } else if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            node = new OptNode(OptNode.NodeType.WHILE);
            if (storeObjs) {
                _rtMap.putMapping(wpb, node);
            }
            node.setExecType(OptNode.ExecType.CP);
            node.addChilds(OptTreeConverter.createOptNodes(wpb.getPredicate(), vars, storeObjs));
            for (ProgramBlock lpb : wpb.getChildBlocks()) {
                node.addChild(OptTreeConverter.rCreateOptNode(lpb, vars, topLevel, storeObjs));
            }
        } else if (pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            node = new OptNode(OptNode.NodeType.FOR);
            if (storeObjs) {
                _rtMap.putMapping(fpb, node);
            }
            node.setExecType(OptNode.ExecType.CP);
            long N = OptimizerUtils.getNumIterations(fpb, vars, 10L);
            node.addParam(OptNode.ParamType.NUM_ITERATIONS, String.valueOf(N));
            node.addChilds(OptTreeConverter.createOptNodes(fpb.getFromInstructions(), vars, storeObjs));
            node.addChilds(OptTreeConverter.createOptNodes(fpb.getToInstructions(), vars, storeObjs));
            node.addChilds(OptTreeConverter.createOptNodes(fpb.getIncrementInstructions(), vars, storeObjs));
            for (ProgramBlock lpb : fpb.getChildBlocks()) {
                node.addChild(OptTreeConverter.rCreateOptNode(lpb, vars, topLevel, storeObjs));
            }
        } else if (pb instanceof ParForProgramBlock) {
            ParForProgramBlock fpb = (ParForProgramBlock)pb;
            node = new OptNode(OptNode.NodeType.PARFOR);
            if (storeObjs) {
                _rtMap.putMapping(fpb, node);
            }
            node.setK(fpb.getDegreeOfParallelism());
            long N = fpb.getNumIterations();
            node.addParam(OptNode.ParamType.NUM_ITERATIONS, N != -1L ? String.valueOf(N) : String.valueOf(10L));
            switch (fpb.getExecMode()) {
                case LOCAL: {
                    node.setExecType(OptNode.ExecType.CP);
                    break;
                }
                case REMOTE_MR: 
                case REMOTE_MR_DP: {
                    node.setExecType(OptNode.ExecType.MR);
                    break;
                }
                case REMOTE_SPARK: 
                case REMOTE_SPARK_DP: {
                    node.setExecType(OptNode.ExecType.SPARK);
                    break;
                }
                default: {
                    node.setExecType(null);
                }
            }
            if (!topLevel) {
                node.addChilds(OptTreeConverter.createOptNodes(fpb.getFromInstructions(), vars, storeObjs));
                node.addChilds(OptTreeConverter.createOptNodes(fpb.getToInstructions(), vars, storeObjs));
                node.addChilds(OptTreeConverter.createOptNodes(fpb.getIncrementInstructions(), vars, storeObjs));
            }
            for (ProgramBlock lpb : fpb.getChildBlocks()) {
                node.addChild(OptTreeConverter.rCreateOptNode(lpb, vars, false, storeObjs));
            }
        } else {
            node = new OptNode(OptNode.NodeType.GENERIC);
            if (storeObjs) {
                _rtMap.putMapping(pb, node);
            }
            node.addChilds(OptTreeConverter.createOptNodes(pb.getInstructions(), vars, storeObjs));
            node.setExecType(OptNode.ExecType.CP);
        }
        return node;
    }

    public static ArrayList<OptNode> createOptNodes(ArrayList<Instruction> instset, LocalVariableMap vars, boolean storeObjs) throws DMLRuntimeException {
        ArrayList<OptNode> tmp = new ArrayList<OptNode>(instset.size());
        for (Instruction inst : instset) {
            tmp.add(OptTreeConverter.createOptNode(inst, vars, storeObjs));
        }
        return tmp;
    }

    public static OptNode createOptNode(Instruction inst, LocalVariableMap vars, boolean storeObjs) throws DMLRuntimeException {
        OptNode node = new OptNode(OptNode.NodeType.INST);
        String instStr = inst.toString();
        String opstr = instStr.split("\u00b0")[1];
        if (storeObjs) {
            _rtMap.putMapping(inst, node);
        }
        node.addParam(OptNode.ParamType.OPSTRING, opstr);
        switch (inst.getType()) {
            case CONTROL_PROGRAM: {
                node.setExecType(OptNode.ExecType.CP);
                break;
            }
            case MAPREDUCE: 
            case MAPREDUCE_JOB: {
                node.setExecType(OptNode.ExecType.MR);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported instruction type.");
            }
        }
        return node;
    }

    public static OptNode rCreateAbstractOptNode(StatementBlock sb, ProgramBlock pb, LocalVariableMap vars, boolean topLevel, Set<String> memo) throws DMLRuntimeException, HopsException {
        OptNode node = null;
        if (pb instanceof IfProgramBlock && sb instanceof IfStatementBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement is = (IfStatement)isb.getStatement(0);
            node = new OptNode(OptNode.NodeType.IF);
            _hlMap.putProgMapping(sb, pb, node);
            node.setExecType(OptNode.ExecType.CP);
            node.setLineNumbers(isb.getBeginLine(), isb.getEndLine());
            isb.getPredicateHops().resetVisitStatus();
            node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(isb.getPredicateHops(), vars, memo));
            OptNode ifn = new OptNode(OptNode.NodeType.GENERIC);
            _hlMap.putProgMapping(sb, pb, ifn);
            ifn.setExecType(OptNode.ExecType.CP);
            node.addChild(ifn);
            int len = is.getIfBody().size();
            for (int i = 0; i < ipb.getChildBlocksIfBody().size() && i < len; ++i) {
                ProgramBlock lpb = ipb.getChildBlocksIfBody().get(i);
                StatementBlock lsb = is.getIfBody().get(i);
                ifn.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
            }
            if (ipb.getChildBlocksElseBody() != null) {
                OptNode efn = new OptNode(OptNode.NodeType.GENERIC);
                _hlMap.putProgMapping(sb, pb, efn);
                efn.setExecType(OptNode.ExecType.CP);
                node.addChild(efn);
                int len2 = is.getElseBody().size();
                for (int i = 0; i < ipb.getChildBlocksElseBody().size() && i < len2; ++i) {
                    ProgramBlock lpb = ipb.getChildBlocksElseBody().get(i);
                    StatementBlock lsb = is.getElseBody().get(i);
                    efn.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
                }
            }
        } else if (pb instanceof WhileProgramBlock && sb instanceof WhileStatementBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement ws = (WhileStatement)wsb.getStatement(0);
            node = new OptNode(OptNode.NodeType.WHILE);
            _hlMap.putProgMapping(sb, pb, node);
            node.setExecType(OptNode.ExecType.CP);
            node.setLineNumbers(wsb.getBeginLine(), wsb.getEndLine());
            wsb.getPredicateHops().resetVisitStatus();
            node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(wsb.getPredicateHops(), vars, memo));
            int len = ws.getBody().size();
            for (int i = 0; i < wpb.getChildBlocks().size() && i < len; ++i) {
                ProgramBlock lpb = wpb.getChildBlocks().get(i);
                StatementBlock lsb = ws.getBody().get(i);
                node.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
            }
        } else if (pb instanceof ForProgramBlock && sb instanceof ForStatementBlock && !(pb instanceof ParForProgramBlock)) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fs = (ForStatement)fsb.getStatement(0);
            node = new OptNode(OptNode.NodeType.FOR);
            _hlMap.putProgMapping(sb, pb, node);
            node.setExecType(OptNode.ExecType.CP);
            node.setLineNumbers(fsb.getBeginLine(), fsb.getEndLine());
            long N = OptimizerUtils.getNumIterations(fpb, vars, 10L);
            node.addParam(OptNode.ParamType.NUM_ITERATIONS, String.valueOf(N));
            fsb.getFromHops().resetVisitStatus();
            fsb.getToHops().resetVisitStatus();
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementHops().resetVisitStatus();
            }
            node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(fsb.getFromHops(), vars, memo));
            node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(fsb.getToHops(), vars, memo));
            if (fsb.getIncrementHops() != null) {
                node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(fsb.getIncrementHops(), vars, memo));
            }
            int len = fs.getBody().size();
            for (int i = 0; i < fpb.getChildBlocks().size() && i < len; ++i) {
                ProgramBlock lpb = fpb.getChildBlocks().get(i);
                StatementBlock lsb = fs.getBody().get(i);
                node.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
            }
        } else if (pb instanceof ParForProgramBlock && sb instanceof ParForStatementBlock) {
            ParForProgramBlock fpb = (ParForProgramBlock)pb;
            ParForStatementBlock fsb = (ParForStatementBlock)sb;
            ParForStatement fs = (ParForStatement)fsb.getStatement(0);
            node = new OptNode(OptNode.NodeType.PARFOR);
            node.setLineNumbers(fsb.getBeginLine(), fsb.getEndLine());
            _hlMap.putProgMapping(sb, pb, node);
            node.setK(fpb.getDegreeOfParallelism());
            long N = fpb.getNumIterations();
            node.addParam(OptNode.ParamType.NUM_ITERATIONS, N != -1L ? String.valueOf(N) : String.valueOf(10L));
            switch (fpb.getExecMode()) {
                case LOCAL: {
                    node.setExecType(OptNode.ExecType.CP);
                    break;
                }
                case REMOTE_MR: 
                case REMOTE_MR_DP: {
                    node.setExecType(OptNode.ExecType.MR);
                    break;
                }
                case REMOTE_SPARK: 
                case REMOTE_SPARK_DP: {
                    node.setExecType(OptNode.ExecType.SPARK);
                    break;
                }
                case UNSPECIFIED: {
                    node.setExecType(null);
                }
            }
            if (!topLevel) {
                fsb.getFromHops().resetVisitStatus();
                fsb.getToHops().resetVisitStatus();
                if (fsb.getIncrementHops() != null) {
                    fsb.getIncrementHops().resetVisitStatus();
                }
                node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(fsb.getFromHops(), vars, memo));
                node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(fsb.getToHops(), vars, memo));
                if (fsb.getIncrementHops() != null) {
                    node.addChilds(OptTreeConverter.rCreateAbstractOptNodes(fsb.getIncrementHops(), vars, memo));
                }
            }
            int len = fs.getBody().size();
            for (int i = 0; i < fpb.getChildBlocks().size() && i < len; ++i) {
                ProgramBlock lpb = fpb.getChildBlocks().get(i);
                StatementBlock lsb = fs.getBody().get(i);
                node.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
            }
            HashMap<String, String> lparams = fpb.getParForParams();
            node.addParam(OptNode.ParamType.DATA_PARTITIONER, (String)lparams.get("datapartitioner"));
            node.addParam(OptNode.ParamType.TASK_PARTITIONER, (String)lparams.get("taskpartitioner"));
            node.addParam(OptNode.ParamType.RESULT_MERGE, (String)lparams.get("resultmerge"));
        } else {
            sb = pb.getStatementBlock();
            node = new OptNode(OptNode.NodeType.GENERIC);
            _hlMap.putProgMapping(sb, pb, node);
            node.addChilds(OptTreeConverter.createAbstractOptNodes(sb.getHops(), vars, memo));
            node.setExecType(OptNode.ExecType.CP);
            node.setLineNumbers(sb.getBeginLine(), sb.getEndLine());
            if (node.isCPOnly()) {
                boolean isSparkExec = OptimizerUtils.isSparkExecutionMode();
                if (!isSparkExec && OptTreeConverter.containsMRJobInstruction(pb, false, false)) {
                    node.setExecType(OptNode.ExecType.MR);
                } else if (isSparkExec && OptTreeConverter.containsMRJobInstruction(pb, false, true)) {
                    node.setExecType(OptNode.ExecType.SPARK);
                }
            }
        }
        node.checkAndCleanupLeafNodes();
        return node;
    }

    public static ArrayList<OptNode> createAbstractOptNodes(ArrayList<Hop> hops, LocalVariableMap vars, Set<String> memo) throws DMLRuntimeException, HopsException {
        ArrayList<OptNode> ret = new ArrayList<OptNode>();
        Hop.resetVisitStatus(hops);
        if (hops != null) {
            for (Hop hop : hops) {
                ret.addAll(OptTreeConverter.rCreateAbstractOptNodes(hop, vars, memo));
            }
        }
        return ret;
    }

    public static ArrayList<OptNode> rCreateAbstractOptNodes(Hop hop, LocalVariableMap vars, Set<String> memo) throws DMLRuntimeException, HopsException {
        ArrayList<OptNode> ret = new ArrayList<OptNode>();
        ArrayList<Hop> in = hop.getInput();
        if (hop.isVisited()) {
            return ret;
        }
        if (!(hop instanceof DataOp || hop instanceof LiteralOp || hop instanceof FunctionOp)) {
            OptNode node = new OptNode(OptNode.NodeType.HOP);
            String opstr = hop.getOpString();
            node.addParam(OptNode.ParamType.OPSTRING, opstr);
            LopProperties.ExecType et = hop.getExecType() != null ? hop.getExecType() : LopProperties.ExecType.CP;
            switch (et) {
                case CP: 
                case GPU: {
                    node.setExecType(OptNode.ExecType.CP);
                    break;
                }
                case SPARK: {
                    node.setExecType(OptNode.ExecType.SPARK);
                    break;
                }
                case MR: {
                    node.setExecType(OptNode.ExecType.MR);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Unsupported optnode exec type: " + (Object)((Object)et));
                }
            }
            if (et == LopProperties.ExecType.CP && hop instanceof Hop.MultiThreadedHop) {
                Hop.MultiThreadedHop mtop = (Hop.MultiThreadedHop)((Object)hop);
                node.setK(OptimizerUtils.getConstrainedNumThreads(mtop.getMaxNumThreads()));
            }
            _hlMap.putHopMapping(hop, node);
            ret.add(node);
        } else if (hop instanceof FunctionOp && INCLUDE_FUNCTIONS) {
            FunctionOp fhop = (FunctionOp)hop;
            String fname = fhop.getFunctionName();
            String fnspace = fhop.getFunctionNamespace();
            String fKey = fhop.getFunctionKey();
            Object[] prog = _hlMap.getRootProgram();
            OptNode node = new OptNode(OptNode.NodeType.FUNCCALL);
            _hlMap.putHopMapping(fhop, node);
            node.setExecType(OptNode.ExecType.CP);
            node.addParam(OptNode.ParamType.OPSTRING, fKey);
            if (!fnspace.equals("_internal")) {
                FunctionProgramBlock fpb = ((Program)prog[1]).getFunctionProgramBlock(fnspace, fname);
                FunctionStatementBlock fsb = ((DMLProgram)prog[0]).getFunctionStatementBlock(fnspace, fname);
                FunctionStatement fs = (FunctionStatement)fsb.getStatement(0);
                if (!memo.contains(fKey)) {
                    memo.add(fKey);
                    int len = fs.getBody().size();
                    for (int i = 0; i < fpb.getChildBlocks().size() && i < len; ++i) {
                        ProgramBlock lpb = fpb.getChildBlocks().get(i);
                        StatementBlock lsb = fs.getBody().get(i);
                        node.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
                    }
                    memo.remove(fKey);
                } else {
                    node.addParam(OptNode.ParamType.RECURSIVE_CALL, "true");
                }
            }
            ret.add(node);
        }
        if (in != null) {
            for (Hop hin : in) {
                if (hin instanceof DataOp || hin instanceof LiteralOp) continue;
                ret.addAll(OptTreeConverter.rCreateAbstractOptNodes(hin, vars, memo));
            }
        }
        hop.setVisited();
        return ret;
    }

    public static boolean rContainsMRJobInstruction(ProgramBlock pb, boolean inclFunctions) {
        boolean ret = false;
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock tmp = (WhileProgramBlock)pb;
            ret = OptTreeConverter.containsMRJobInstruction(tmp.getPredicate(), true, true);
            if (ret) {
                return ret;
            }
            for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                ret = OptTreeConverter.rContainsMRJobInstruction(pb2, inclFunctions);
                if (!ret) continue;
                return ret;
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock tmp = (IfProgramBlock)pb;
            ret = OptTreeConverter.containsMRJobInstruction(tmp.getPredicate(), true, true);
            if (ret) {
                return ret;
            }
            for (ProgramBlock pb2 : tmp.getChildBlocksIfBody()) {
                ret = OptTreeConverter.rContainsMRJobInstruction(pb2, inclFunctions);
                if (!ret) continue;
                return ret;
            }
            for (ProgramBlock pb2 : tmp.getChildBlocksElseBody()) {
                ret = OptTreeConverter.rContainsMRJobInstruction(pb2, inclFunctions);
                if (!ret) continue;
                return ret;
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock tmp = (ForProgramBlock)pb;
            ret = OptTreeConverter.containsMRJobInstruction(tmp.getFromInstructions(), true, true);
            ret |= OptTreeConverter.containsMRJobInstruction(tmp.getToInstructions(), true, true);
            if (ret |= OptTreeConverter.containsMRJobInstruction(tmp.getIncrementInstructions(), true, true)) {
                return ret;
            }
            for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                ret = OptTreeConverter.rContainsMRJobInstruction(pb2, inclFunctions);
                if (!ret) continue;
                return ret;
            }
        } else if (!(pb instanceof FunctionProgramBlock)) {
            ret = OptTreeConverter.containsMRJobInstruction(pb, true, true) || inclFunctions && OptTreeConverter.containsFunctionCallInstruction(pb);
        }
        return ret;
    }

    public static boolean containsMRJobInstruction(ProgramBlock pb, boolean inclCPFile, boolean inclSpark) {
        return OptTreeConverter.containsMRJobInstruction(pb.getInstructions(), inclCPFile, inclSpark);
    }

    public static boolean containsMRJobInstruction(ArrayList<Instruction> instSet, boolean inclCPFile, boolean inclSpark) {
        return instSet.stream().anyMatch(inst -> inst instanceof MRJobInstruction || inclSpark && inst instanceof SPInstruction || inclCPFile && (inst instanceof MatrixIndexingCPFileInstruction || inst instanceof ParameterizedBuiltinCPFileInstruction));
    }

    public static boolean containsFunctionCallInstruction(ProgramBlock pb) {
        return pb.getInstructions().stream().anyMatch(inst -> inst instanceof FunctionCallCPInstruction);
    }

    public static void replaceProgramBlock(OptNode parent, OptNode n, ProgramBlock pbOld, ProgramBlock pbNew, boolean rtMap) throws DMLRuntimeException {
        ProgramBlock fpb;
        ProgramBlock pbParent = null;
        if (rtMap) {
            pbParent = (ProgramBlock)_rtMap.getMappedObject(parent.getID());
        } else if (parent.getNodeType() == OptNode.NodeType.FUNCCALL) {
            FunctionOp fop = (FunctionOp)_hlMap.getMappedHop(parent.getID());
            pbParent = ((Program)_hlMap.getRootProgram()[1]).getFunctionProgramBlock(fop.getFunctionNamespace(), fop.getFunctionName());
        } else {
            pbParent = (ProgramBlock)_hlMap.getMappedProg(parent.getID())[1];
        }
        if (pbParent instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pbParent;
            OptTreeConverter.replaceProgramBlock(ipb.getChildBlocksIfBody(), pbOld, pbNew);
            OptTreeConverter.replaceProgramBlock(ipb.getChildBlocksElseBody(), pbOld, pbNew);
        } else if (pbParent instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pbParent;
            OptTreeConverter.replaceProgramBlock(wpb.getChildBlocks(), pbOld, pbNew);
        } else if (pbParent instanceof ForProgramBlock || pbParent instanceof ParForProgramBlock) {
            fpb = (ForProgramBlock)pbParent;
            OptTreeConverter.replaceProgramBlock(((ForProgramBlock)fpb).getChildBlocks(), pbOld, pbNew);
        } else if (pbParent instanceof FunctionProgramBlock) {
            fpb = (FunctionProgramBlock)pbParent;
            OptTreeConverter.replaceProgramBlock(((FunctionProgramBlock)fpb).getChildBlocks(), pbOld, pbNew);
        } else {
            throw new DMLRuntimeException("Optimizer doesn't support " + pbParent.getClass().getName());
        }
        if (rtMap) {
            _rtMap.replaceMapping(pbNew, n);
        } else {
            _hlMap.replaceMapping(pbNew, n);
        }
    }

    public static void replaceProgramBlock(ArrayList<ProgramBlock> pbs, ProgramBlock pbOld, ProgramBlock pbNew) {
        int len = pbs.size();
        for (int i = 0; i < len; ++i) {
            if (pbs.get(i) != pbOld) continue;
            pbs.set(i, pbNew);
        }
    }

    public static OptTreePlanMappingAbstract getAbstractPlanMapping() {
        return _hlMap;
    }

    public static void clear() {
        if (_hlMap != null) {
            _hlMap.clear();
        }
        if (_rtMap != null) {
            _rtMap.clear();
        }
    }

    static {
        _hlMap = new OptTreePlanMappingAbstract();
        _rtMap = new OptTreePlanMappingRuntime();
    }
}

