/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.LinkedList;
import java.util.List;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.LocalTaskQueue;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.TaskPartitioner;
import org.apache.sysml.runtime.instructions.cp.IntObject;

public class TaskPartitionerFixedsize
extends TaskPartitioner {
    protected int _firstnPlus1 = 0;

    public TaskPartitionerFixedsize(long taskSize, String iterVarName, IntObject fromVal, IntObject toVal, IntObject incrVal) {
        super(taskSize, iterVarName, fromVal, toVal, incrVal);
    }

    @Override
    public List<Task> createTasks() throws DMLRuntimeException {
        LinkedList<Task> tasks = new LinkedList<Task>();
        Task.TaskType type = this._taskSize > 3L ? Task.TaskType.RANGE : Task.TaskType.SET;
        long lFrom = this._fromVal.getLongValue();
        long lTo = this._toVal.getLongValue();
        long lIncr = this._incrVal.getLongValue();
        long lfnp1 = this._firstnPlus1;
        long i = lFrom;
        while (i <= lTo) {
            int corr;
            Task lTask = new Task(this._iterVarName, type);
            tasks.addLast(lTask);
            int n = corr = lfnp1-- > 0L ? 1 : 0;
            if (type == Task.TaskType.SET) {
                for (long j = 0L; j < this._taskSize + (long)corr && i <= lTo; ++j, i += lIncr) {
                    lTask.addIteration(new IntObject(i));
                }
                continue;
            }
            long to = Math.min(i + (this._taskSize - 1L + (long)corr) * lIncr, lTo);
            lTask.addIteration(new IntObject(i));
            lTask.addIteration(new IntObject(to));
            lTask.addIteration(new IntObject(lIncr));
            i = to + lIncr;
        }
        return tasks;
    }

    @Override
    public long createTasks(LocalTaskQueue<Task> queue) throws DMLRuntimeException {
        long numCreatedTasks = 0L;
        Task.TaskType type = this._taskSize > 3L ? Task.TaskType.RANGE : Task.TaskType.SET;
        long lFrom = this._fromVal.getLongValue();
        long lTo = this._toVal.getLongValue();
        long lIncr = this._incrVal.getLongValue();
        long lfnp1 = this._firstnPlus1;
        try {
            long i = lFrom;
            while (i <= lTo) {
                int corr;
                Task lTask = new Task(this._iterVarName, type);
                int n = corr = lfnp1-- > 0L ? 1 : 0;
                if (type == Task.TaskType.SET) {
                    for (long j = 0L; j < this._taskSize + (long)corr && i <= lTo; ++j, i += lIncr) {
                        lTask.addIteration(new IntObject(i));
                    }
                } else {
                    long to = Math.min(i + (this._taskSize - 1L + (long)corr) * lIncr, lTo);
                    lTask.addIteration(new IntObject(i));
                    lTask.addIteration(new IntObject(to));
                    lTask.addIteration(new IntObject(lIncr));
                    i = to + lIncr;
                }
                queue.enqueueTask(lTask);
                ++numCreatedTasks;
            }
            queue.closeInput();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return numCreatedTasks;
    }
}

