/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMergeLocalFile;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMergeLocalMemory;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptimizerRuleBased;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class ResultMergeLocalAutomatic
extends ResultMerge {
    private static final long serialVersionUID = 1600893100602101732L;
    private ResultMerge _rm = null;

    public ResultMergeLocalAutomatic(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super(out, in, outputFilename, accum);
    }

    @Override
    public MatrixObject executeSerialMerge() throws DMLRuntimeException {
        long cols;
        Timing time = new Timing(true);
        MatrixCharacteristics mc = this._output.getMatrixCharacteristics();
        long rows = mc.getRows();
        this._rm = OptimizerRuleBased.isInMemoryResultMerge(rows, cols = mc.getCols(), OptimizerUtils.getLocalMemBudget()) ? new ResultMergeLocalMemory(this._output, this._inputs, this._outputFName, this._isAccum) : new ResultMergeLocalFile(this._output, this._inputs, this._outputFName, this._isAccum);
        MatrixObject ret = this._rm.executeSerialMerge();
        LOG.trace((Object)("Automatic result merge (" + this._rm.getClass().getName() + ") executed in " + time.stop() + "ms."));
        return ret;
    }

    @Override
    public MatrixObject executeParallelMerge(int par) throws DMLRuntimeException {
        long cols;
        MatrixCharacteristics mc = this._output.getMatrixCharacteristics();
        long rows = mc.getRows();
        this._rm = OptimizerRuleBased.isInMemoryResultMerge((long)par * rows, cols = mc.getCols(), OptimizerUtils.getLocalMemBudget()) ? new ResultMergeLocalMemory(this._output, this._inputs, this._outputFName, this._isAccum) : new ResultMergeLocalFile(this._output, this._inputs, this._outputFName, this._isAccum);
        return this._rm.executeParallelMerge(par);
    }
}

