/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Stat;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.utils.Statistics;
import scala.Tuple2;

public class RemoteParForUtils {
    public static void incrementParForMRCounters(Reporter reporter, long deltaTasks, long deltaIterations) {
        if (deltaTasks > 0L) {
            reporter.incrCounter("SystemML ParFOR Counters", Stat.PARFOR_NUMTASKS.toString(), deltaTasks);
        }
        if (deltaIterations > 0L) {
            reporter.incrCounter("SystemML ParFOR Counters", Stat.PARFOR_NUMITERS.toString(), deltaIterations);
        }
        JobConf job = ConfigurationManager.getCachedJobConf();
        if (DMLScript.STATISTICS && !InfrastructureAnalyzer.isLocalMode(job)) {
            reporter.incrCounter("SystemML ParFOR Counters", Stat.PARFOR_JITCOMPILE.toString(), Statistics.getJITCompileTime());
            reporter.incrCounter("SystemML ParFOR Counters", Stat.PARFOR_JVMGC_COUNT.toString(), Statistics.getJVMgcCount());
            reporter.incrCounter("SystemML ParFOR Counters", Stat.PARFOR_JVMGC_TIME.toString(), Statistics.getJVMgcTime());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_HITS_MEM.toString(), CacheStatistics.getMemHits());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_HITS_FSBUFF.toString(), CacheStatistics.getFSBuffHits());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_HITS_FS.toString(), CacheStatistics.getFSHits());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_HITS_HDFS.toString(), CacheStatistics.getHDFSHits());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_WRITES_FSBUFF.toString(), CacheStatistics.getFSBuffWrites());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_WRITES_FS.toString(), CacheStatistics.getFSWrites());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_WRITES_HDFS.toString(), CacheStatistics.getHDFSWrites());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_TIME_ACQR.toString(), CacheStatistics.getAcquireRTime());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_TIME_ACQM.toString(), CacheStatistics.getAcquireMTime());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_TIME_RLS.toString(), CacheStatistics.getReleaseTime());
            reporter.incrCounter("SystemML Caching Counters", CacheStatistics.Stat.CACHE_TIME_EXP.toString(), CacheStatistics.getExportTime());
            CacheStatistics.reset();
        }
    }

    public static void exportResultVariables(long workerID, LocalVariableMap vars, ArrayList<ParForStatementBlock.ResultVar> resultVars, OutputCollector<Writable, Writable> out) throws DMLRuntimeException, IOException {
        RemoteParForUtils.exportResultVariables(workerID, vars, resultVars, null, out);
    }

    public static void exportResultVariables(long workerID, LocalVariableMap vars, ArrayList<ParForStatementBlock.ResultVar> resultVars, HashMap<String, String> rvarFnames, OutputCollector<Writable, Writable> out) throws DMLRuntimeException, IOException {
        LongWritable okey = new LongWritable(workerID);
        Text ovalue = new Text();
        for (ParForStatementBlock.ResultVar rvar : resultVars) {
            MatrixObject mo;
            Data dat = vars.get(rvar._name);
            if (dat == null || dat.getDataType() != Expression.DataType.MATRIX || !(mo = (MatrixObject)dat).isDirty()) continue;
            if (ParForProgramBlock.ALLOW_REUSE_MR_PAR_WORKER && rvarFnames != null) {
                String fname = rvarFnames.get(rvar._name);
                if (fname != null) {
                    mo.setFileName(fname);
                }
                mo.exportData();
                rvarFnames.put(rvar._name, mo.getFileName());
            } else {
                mo.exportData();
            }
            String datStr = ProgramConverter.serializeDataObject(rvar._name, mo);
            ovalue.set(datStr);
            out.collect((Object)okey, (Object)ovalue);
        }
    }

    public static ArrayList<String> exportResultVariables(long workerID, LocalVariableMap vars, ArrayList<ParForStatementBlock.ResultVar> resultVars) throws DMLRuntimeException, IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (ParForStatementBlock.ResultVar rvar : resultVars) {
            MatrixObject mo;
            Data dat = vars.get(rvar._name);
            if (dat == null || dat.getDataType() != Expression.DataType.MATRIX || !(mo = (MatrixObject)dat).isDirty()) continue;
            mo.exportData();
            ret.add(ProgramConverter.serializeDataObject(rvar._name, mo));
        }
        return ret;
    }

    public static void cleanupWorkingDirectories() {
        JobConf job = ConfigurationManager.getCachedJobConf();
        if (!InfrastructureAnalyzer.isLocalMode(job)) {
            CacheableData.cleanupCacheDir();
            CacheableData.disableCaching();
            LocalFileUtils.cleanupWorkingDirectory();
        }
    }

    public static void cleanupWorkingDirectoriesOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new DeleteWorkingDirectoriesTask());
    }

    public static LocalVariableMap[] getResults(List<Tuple2<Long, String>> out, Log LOG) throws DMLRuntimeException {
        HashMap<Long, LocalVariableMap> tmp = new HashMap<Long, LocalVariableMap>();
        int countAll = 0;
        for (Tuple2<Long, String> entry : out) {
            Long key = (Long)entry._1();
            String val = (String)entry._2();
            if (!tmp.containsKey(key)) {
                tmp.put(key, new LocalVariableMap());
            }
            Object[] dat = ProgramConverter.parseDataObject(val);
            ((LocalVariableMap)tmp.get(key)).put((String)dat[0], (Data)dat[1]);
            ++countAll;
        }
        if (LOG != null) {
            LOG.debug((Object)("Num remote worker results (before deduplication): " + countAll));
            LOG.debug((Object)("Num remote worker results: " + tmp.size()));
        }
        return tmp.values().toArray(new LocalVariableMap[0]);
    }

    private static class DeleteWorkingDirectoriesTask
    extends Thread {
        private DeleteWorkingDirectoriesTask() {
        }

        @Override
        public void run() {
            RemoteParForUtils.cleanupWorkingDirectories();
        }
    }
}

