/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.io.Writable;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableBlock;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import scala.Tuple2;

public class DataPartitionerRemoteSparkMapper
extends ParWorker
implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, Long, Writable> {
    private static final long serialVersionUID = 332887624852010957L;
    private final long _rlen;
    private final long _clen;
    private final long _brlen;
    private final long _bclen;
    private ParForProgramBlock.PDataPartitionFormat _dpf;
    private final long _n;

    public DataPartitionerRemoteSparkMapper(MatrixCharacteristics mc, InputInfo ii, OutputInfo oi, ParForProgramBlock.PDataPartitionFormat dpf, int n) throws DMLRuntimeException {
        this._rlen = mc.getRows();
        this._clen = mc.getCols();
        this._brlen = mc.getRowsPerBlock();
        this._bclen = mc.getColsPerBlock();
        this._dpf = dpf;
        this._n = n;
    }

    public Iterator<Tuple2<Long, Writable>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        LinkedList<Tuple2> ret = new LinkedList<Tuple2>();
        MatrixIndexes key2 = (MatrixIndexes)arg0._1();
        MatrixBlock value2 = (MatrixBlock)arg0._2();
        long row_offset = (key2.getRowIndex() - 1L) * this._brlen;
        long col_offset = (key2.getColumnIndex() - 1L) * this._bclen;
        long rows = value2.getNumRows();
        long cols = value2.getNumColumns();
        if (row_offset + rows < 1L || row_offset + rows > this._rlen || col_offset + cols < 1L || col_offset + cols > this._clen) {
            throw new IOException("Matrix block [" + (row_offset + 1L) + ":" + (row_offset + rows) + "," + (col_offset + 1L) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "].");
        }
        switch (this._dpf) {
            case ROW_WISE: {
                MatrixBlock[] blks = DataConverter.convertToMatrixBlockPartitions(value2, false);
                int i = 0;
                while ((long)i < rows) {
                    PairWritableBlock tmp = new PairWritableBlock();
                    tmp.indexes = new MatrixIndexes(1L, col_offset / this._bclen + 1L);
                    tmp.block = blks[i];
                    ret.add(new Tuple2((Object)new Long(row_offset + 1L + (long)i), (Object)tmp));
                    ++i;
                }
                break;
            }
            case ROW_BLOCK_WISE: {
                PairWritableBlock tmp = new PairWritableBlock();
                tmp.indexes = new MatrixIndexes(1L, col_offset / this._bclen + 1L);
                tmp.block = new MatrixBlock(value2);
                ret.add(new Tuple2((Object)new Long(row_offset / this._brlen + 1L), (Object)tmp));
                break;
            }
            case ROW_BLOCK_WISE_N: {
                if (this._n >= this._brlen) {
                    PairWritableBlock tmp = new PairWritableBlock();
                    tmp.indexes = new MatrixIndexes(row_offset % this._n / this._brlen + 1L, col_offset / this._bclen + 1L);
                    tmp.block = new MatrixBlock(value2);
                    ret.add(new Tuple2((Object)new Long(row_offset / this._n + 1L), (Object)tmp));
                    break;
                }
                int i = 0;
                while ((long)i < rows) {
                    PairWritableBlock tmp = new PairWritableBlock();
                    tmp.indexes = new MatrixIndexes(1L, col_offset / this._bclen + 1L);
                    tmp.block = value2.slice(i, Math.min(i + (int)this._n - 1, value2.getNumRows() - 1), 0, value2.getNumColumns() - 1, new MatrixBlock());
                    ret.add(new Tuple2((Object)new Long((row_offset + (long)i) / this._n + 1L), (Object)tmp));
                    i = (int)((long)i + this._n);
                }
                break;
            }
            case COLUMN_WISE: {
                MatrixBlock[] blks = DataConverter.convertToMatrixBlockPartitions(value2, true);
                int i = 0;
                while ((long)i < cols) {
                    PairWritableBlock tmp = new PairWritableBlock();
                    tmp.indexes = new MatrixIndexes(row_offset / this._brlen + 1L, 1L);
                    tmp.block = blks[i];
                    ret.add(new Tuple2((Object)new Long(col_offset + 1L + (long)i), (Object)tmp));
                    ++i;
                }
                break;
            }
            case COLUMN_BLOCK_WISE: {
                PairWritableBlock tmp = new PairWritableBlock();
                tmp.indexes = new MatrixIndexes(row_offset / this._brlen + 1L, 1L);
                tmp.block = new MatrixBlock(value2);
                ret.add(new Tuple2((Object)new Long(col_offset / this._bclen + 1L), (Object)tmp));
                break;
            }
            case COLUMN_BLOCK_WISE_N: {
                if (this._n >= this._bclen) {
                    PairWritableBlock tmp = new PairWritableBlock();
                    tmp.indexes = new MatrixIndexes(row_offset / this._brlen + 1L, col_offset % this._n / this._bclen + 1L);
                    tmp.block = new MatrixBlock(value2);
                    ret.add(new Tuple2((Object)new Long(col_offset / this._n + 1L), (Object)tmp));
                    break;
                }
                int i = 0;
                while ((long)i < cols) {
                    PairWritableBlock tmp = new PairWritableBlock();
                    tmp.indexes = new MatrixIndexes(row_offset / this._brlen + 1L, 1L);
                    tmp.block = value2.slice(0, value2.getNumRows() - 1, i, Math.min(i + (int)this._n - 1, value2.getNumColumns() - 1), new MatrixBlock());
                    ret.add(new Tuple2((Object)new Long((col_offset + (long)i) / this._n + 1L), (Object)tmp));
                    i = (int)((long)i + this._n);
                }
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported partition format: " + (Object)((Object)this._dpf));
            }
        }
        return ret.iterator();
    }
}

