/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysml.runtime.matrix.data.LibMatrixMult;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;
import org.apache.sysml.runtime.util.SortUtils;

public class ColGroupUncompressed
extends ColGroup {
    private static final long serialVersionUID = 4870546053280378891L;
    private MatrixBlock _data;

    public ColGroupUncompressed() {
        super((int[])null, -1);
    }

    public ColGroupUncompressed(List<Integer> colIndicesList, MatrixBlock rawblock) throws DMLRuntimeException {
        super(colIndicesList, rawblock.getNumColumns());
        int numRows = rawblock.getNumColumns();
        this._data = new MatrixBlock(numRows, this._colIndexes.length, rawblock.isInSparseFormat());
        if (!SortUtils.isSorted(0, this._colIndexes.length, this._colIndexes)) {
            Arrays.sort(this._colIndexes);
        }
        if (rawblock.isEmptyBlock(false)) {
            return;
        }
        int m = numRows;
        int n = this._colIndexes.length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double val = rawblock.quickGetValue(this._colIndexes[j], i);
                this._data.appendValue(i, j, val);
            }
        }
        this._data.examSparsity();
        if (this._data.isInSparseFormat()) {
            this._data = new MatrixBlock(this._data, SparseBlock.Type.CSR, false);
        }
    }

    public ColGroupUncompressed(List<ColGroup> groupsToDecompress) {
        super(ColGroupUncompressed.mergeColIndices(groupsToDecompress), groupsToDecompress.get((int)0)._numRows);
        int maxColIndex = this._colIndexes[this._colIndexes.length - 1];
        int[] colIndicesInverted = new int[maxColIndex + 1];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            colIndicesInverted[this._colIndexes[i]] = i;
        }
        this._data = new MatrixBlock(this._numRows, this._colIndexes.length, false);
        for (ColGroup colGroup : groupsToDecompress) {
            colGroup.decompressToBlock(this._data, colIndicesInverted);
        }
    }

    public ColGroupUncompressed(int[] colIndices, int numRows, MatrixBlock data) {
        super(colIndices, numRows);
        this._data = data;
    }

    @Override
    public ColGroup.CompressionType getCompType() {
        return ColGroup.CompressionType.UNCOMPRESSED;
    }

    public MatrixBlock getData() {
        return this._data;
    }

    private static int[] mergeColIndices(List<ColGroup> groupsToDecompress) {
        int sz = 0;
        for (ColGroup colGroup : groupsToDecompress) {
            sz += colGroup.getNumCols();
        }
        int[] ret = new int[sz];
        int pos = 0;
        for (ColGroup colGroup : groupsToDecompress) {
            int[] tmp = colGroup.getColIndices();
            System.arraycopy(tmp, 0, ret, pos, tmp.length);
            pos += tmp.length;
        }
        Arrays.sort(ret);
        return ret;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size + 8L + this._data.estimateSizeInMemory();
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        if (this._data.isEmptyBlock(false)) {
            return;
        }
        for (int row = rl; row < ru; ++row) {
            for (int colIx = 0; colIx < this._colIndexes.length; ++colIx) {
                int col = this._colIndexes[colIx];
                double cellVal = this._data.quickGetValue(row, colIx);
                target.quickSetValue(row, col, cellVal);
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colIndexTargets) {
        if (this._data.isEmptyBlock(false)) {
            return;
        }
        for (int row = 0; row < this._data.getNumRows(); ++row) {
            for (int colIx = 0; colIx < this._data.getNumColumns(); ++colIx) {
                int origMatrixColIx = this.getColIndex(colIx);
                int col = colIndexTargets[origMatrixColIx];
                double cellVal = this._data.quickGetValue(row, colIx);
                target.quickSetValue(row, col, cellVal);
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        if (this._data.isEmptyBlock(false)) {
            return;
        }
        for (int row = 0; row < this._data.getNumRows(); ++row) {
            double cellVal = this._data.quickGetValue(row, colpos);
            target.quickSetValue(row, 0, cellVal);
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in uncompressed group.");
        }
        return this._data.quickGetValue(r, ix);
    }

    @Override
    public void rightMultByVector(MatrixBlock vector, MatrixBlock result, int rl, int ru) throws DMLRuntimeException {
        int clen = this._colIndexes.length;
        MatrixBlock shortVector = new MatrixBlock(clen, 1, false);
        shortVector.allocateDenseBlock();
        double[] b = shortVector.getDenseBlockValues();
        for (int colIx = 0; colIx < clen; ++colIx) {
            b[colIx] = vector.quickGetValue(this._colIndexes[colIx], 0);
        }
        shortVector.recomputeNonZeros();
        LibMatrixMult.matrixMult(this._data, shortVector, result, rl, ru);
    }

    public void rightMultByVector(MatrixBlock vector, MatrixBlock result, int k) throws DMLRuntimeException {
        int clen = this._colIndexes.length;
        MatrixBlock shortVector = new MatrixBlock(clen, 1, false);
        shortVector.allocateDenseBlock();
        double[] b = shortVector.getDenseBlockValues();
        for (int colIx = 0; colIx < clen; ++colIx) {
            b[colIx] = vector.quickGetValue(this._colIndexes[colIx], 0);
        }
        shortVector.recomputeNonZeros();
        LibMatrixMult.matrixMult(this._data, shortVector, result, k);
    }

    @Override
    public void leftMultByRowVector(MatrixBlock vector, MatrixBlock result) throws DMLRuntimeException {
        MatrixBlock pret = new MatrixBlock(1, this._colIndexes.length, false);
        LibMatrixMult.matrixMult(vector, this._data, pret);
        if (!pret.isEmptyBlock(false)) {
            double[] rsltArr = result.getDenseBlockValues();
            for (int colIx = 0; colIx < this._colIndexes.length; ++colIx) {
                rsltArr[this._colIndexes[colIx]] = pret.quickGetValue(0, colIx);
            }
            result.recomputeNonZeros();
        }
    }

    public void leftMultByRowVector(MatrixBlock vector, MatrixBlock result, int k) throws DMLRuntimeException {
        MatrixBlock pret = new MatrixBlock(1, this._colIndexes.length, false);
        LibMatrixMult.matrixMult(vector, this._data, pret, k);
        if (!pret.isEmptyBlock(false)) {
            double[] rsltArr = result.getDenseBlockValues();
            for (int colIx = 0; colIx < this._colIndexes.length; ++colIx) {
                rsltArr[this._colIndexes[colIx]] = pret.quickGetValue(0, colIx);
            }
            result.recomputeNonZeros();
        }
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) throws DMLRuntimeException {
        MatrixBlock retContent = (MatrixBlock)this._data.scalarOperations(op, new MatrixBlock());
        return new ColGroupUncompressed(this.getColIndices(), this._data.getNumRows(), retContent);
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, MatrixBlock ret) throws DMLRuntimeException {
        LibMatrixAgg.aggregateUnaryMatrix(this._data, ret, op);
        if (op.indexFn instanceof ReduceRow) {
            for (int i = this._colIndexes.length - 1; i >= 0; --i) {
                double val = ret.quickGetValue(0, i);
                ret.quickSetValue(0, i, 0.0);
                ret.quickSetValue(0, this._colIndexes[i], val);
                if (!op.aggOp.correctionExists) continue;
                for (int j = 1; j < ret.getNumRows(); ++j) {
                    double corr = ret.quickGetValue(j, i);
                    ret.quickSetValue(j, i, 0.0);
                    ret.quickSetValue(j, this._colIndexes[i], corr);
                }
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this._data = new MatrixBlock();
        this._data.readFields(in);
        this._numRows = this._data.getNumRows();
        int numCols = this._data.getNumColumns();
        this._colIndexes = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            this._colIndexes[i] = in.readInt();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this._data.write(out);
        int len = this._data.getNumColumns();
        for (int i = 0; i < len; ++i) {
            out.writeInt(this._colIndexes[i]);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        return this._data.getExactSizeOnDisk() + (long)(4 * this._data.getNumColumns());
    }

    @Override
    protected void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            int n = i - rl;
            rnnz[n] = (int)((long)rnnz[n] + this._data.recomputeNonZeros(i, i, 0, this._data.getNumColumns() - 1));
        }
    }

    @Override
    public Iterator<IJV> getIterator(int rl, int ru, boolean inclZeros, boolean rowMajor) {
        return new UCIterator(rl, ru, inclZeros);
    }

    @Override
    public ColGroup.ColGroupRowIterator getRowIterator(int rl, int ru) {
        return new UCRowIterator(rl, ru);
    }

    private class UCRowIterator
    extends ColGroup.ColGroupRowIterator {
        public UCRowIterator(int rl, int ru) {
            super(ColGroupUncompressed.this);
        }

        @Override
        public void next(double[] buff, int rowIx, int segIx, boolean last) {
            block2: {
                block3: {
                    if (!ColGroupUncompressed.this._data.isAllocated()) break block2;
                    if (!ColGroupUncompressed.this._data.isInSparseFormat()) break block3;
                    if (ColGroupUncompressed.this._data.getSparseBlock().isEmpty(rowIx)) break block2;
                    SparseBlock sblock = ColGroupUncompressed.this._data.getSparseBlock();
                    int apos = sblock.pos(rowIx);
                    int alen = sblock.size(rowIx);
                    int[] aix = sblock.indexes(rowIx);
                    double[] avals = sblock.values(rowIx);
                    for (int k = apos; k < apos + alen; ++k) {
                        buff[ColGroupUncompressed.this._colIndexes[aix[k]]] = avals[k];
                    }
                    break block2;
                }
                int clen = ColGroupUncompressed.this.getNumCols();
                double[] a = ColGroupUncompressed.this._data.getDenseBlockValues();
                int aix = rowIx * clen;
                for (int j = 0; j < clen; ++j) {
                    buff[ColGroupUncompressed.this._colIndexes[j]] = a[aix + j];
                }
            }
        }
    }

    private class UCIterator
    implements Iterator<IJV> {
        private final int _ru;
        private final boolean _inclZeros;
        private final IJV _buff = new IJV();
        private int _rpos = -1;
        private int _cpos = -1;
        private double _value = 0.0;

        public UCIterator(int rl, int ru, boolean inclZeros) {
            this._ru = ru;
            this._inclZeros = inclZeros;
            this._rpos = rl;
            this._cpos = -1;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public IJV next() {
            this._buff.set(this._rpos, ColGroupUncompressed.this._colIndexes[this._cpos], this._value);
            this.getNextValue();
            return this._buff;
        }

        private void getNextValue() {
            do {
                boolean nextRow = this._cpos + 1 >= ColGroupUncompressed.this.getNumCols();
                this._rpos += nextRow ? 1 : 0;
                int n = this._cpos = nextRow ? 0 : this._cpos + 1;
                if (this._rpos >= this._ru) {
                    return;
                }
                this._value = ColGroupUncompressed.this._data.quickGetValue(this._rpos, this._cpos);
            } while (!this._inclZeros && this._value == 0.0);
        }
    }
}

