/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.ColGroupValue;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.compress.utils.LinearAlgebraUtils;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.KahanPlusSq;
import org.apache.sysml.runtime.functionobjects.ReduceAll;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;

public abstract class ColGroupOffset
extends ColGroupValue {
    private static final long serialVersionUID = -1635828933479403125L;
    protected static final boolean CREATE_SKIPLIST = true;
    protected static final int READ_CACHE_BLKSZ = 131072;
    public static final int WRITE_CACHE_BLKSZ = 131072;
    public static boolean ALLOW_CACHE_CONSCIOUS_ROWSUMS = true;
    protected int[] _ptr;
    protected char[] _data;
    protected boolean _zeros;
    protected int[] _skiplist;

    public ColGroupOffset() {
    }

    public ColGroupOffset(int[] colIndices, int numRows, UncompressedBitmap ubm) {
        super(colIndices, numRows, ubm);
        this._zeros = ubm.getNumOffsets() < (long)numRows;
    }

    protected ColGroupOffset(int[] colIndices, int numRows, boolean zeros, double[] values) {
        super(colIndices, numRows, values);
        this._zeros = zeros;
    }

    protected final int len(int k) {
        return this._ptr[k + 1] - this._ptr[k];
    }

    protected void createCompressedBitmaps(int numVals, int totalLen, char[][] lbitmaps) {
        this._ptr = new int[numVals + 1];
        this._data = new char[totalLen];
        int off = 0;
        for (int i = 0; i < numVals; ++i) {
            int len = lbitmaps[i].length;
            this._ptr[i] = off;
            System.arraycopy(lbitmaps[i], 0, this._data, off, len);
            off += len;
        }
        this._ptr[numVals] = totalLen;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += 16L;
        if (this._data != null) {
            size += (long)(32 + this._ptr.length * 4);
            size += (long)(32 + this._data.length * 2);
        }
        return size;
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int[] colIndices = this.getColIndices();
        block0: for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                if (row < rl) continue;
                if (row > ru) continue block0;
                for (int colIx = 0; colIx < numCols; ++colIx) {
                    target.appendValue(row, colIndices[colIx], this._values[valOff + colIx]);
                }
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colIndexTargets) {
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                for (int colIx = 0; colIx < numCols; ++colIx) {
                    int origMatrixColIx = this.getColIndex(colIx);
                    int targetColIx = colIndexTargets[origMatrixColIx];
                    target.quickSetValue(row, targetColIx, this._values[valOff + colIx]);
                }
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                target.quickSetValue(row, 0, this._values[valOff + colpos]);
            }
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in bitmap group.");
        }
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        block0: for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                if (row == r) {
                    return this._values[valOff + ix];
                }
                if (row <= r) continue;
                continue block0;
            }
        }
        return 0.0;
    }

    protected final void sumAllValues(double[] b, double[] c) {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int i = 0;
        int off = 0;
        while (i < numCols) {
            LinearAlgebraUtils.vectMultiplyAdd(b[i], this._values, c, off, 0, numVals);
            ++i;
            off += numVals;
        }
    }

    protected final double mxxValues(int bitmapIx, Builtin builtin) {
        int numCols = this.getNumCols();
        int valOff = bitmapIx * numCols;
        double val = builtin.getBuiltinCode() == Builtin.BuiltinCode.MAX ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (int i = 0; i < numCols; ++i) {
            val = builtin.execute2(val, this._values[valOff + i]);
        }
        return val;
    }

    public char[] getBitmaps() {
        return this._data;
    }

    public int[] getBitmapOffsets() {
        return this._ptr;
    }

    public boolean hasZeros() {
        return this._zeros;
    }

    protected int[] computeOffsets(boolean[] ind) throws DMLRuntimeException {
        int numOffsets = 0;
        for (int i = 0; i < ind.length; ++i) {
            numOffsets += ind[i] ? 1 : 0;
        }
        int[] ret = new int[numOffsets];
        int pos = 0;
        for (int i = 0; i < ind.length; ++i) {
            if (!ind[i]) continue;
            ret[pos++] = i;
        }
        return ret;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        this._numRows = in.readInt();
        int numCols = in.readInt();
        int numVals = in.readInt();
        this._zeros = in.readBoolean();
        this._colIndexes = new int[numCols];
        for (i = 0; i < numCols; ++i) {
            this._colIndexes[i] = in.readInt();
        }
        this._values = new double[numVals * numCols];
        for (i = 0; i < numVals * numCols; ++i) {
            this._values[i] = in.readDouble();
        }
        int totalLen = in.readInt();
        this._ptr = new int[numVals + 1];
        this._data = new char[totalLen];
        int off = 0;
        for (int i2 = 0; i2 < numVals; ++i2) {
            int len = in.readInt();
            this._ptr[i2] = off;
            for (int j = 0; j < len; ++j) {
                this._data[off + j] = in.readChar();
            }
            off += len;
        }
        this._ptr[numVals] = totalLen;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        int i2;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        out.writeInt(this._numRows);
        out.writeInt(numCols);
        out.writeInt(numVals);
        out.writeBoolean(this._zeros);
        for (i2 = 0; i2 < this._colIndexes.length; ++i2) {
            out.writeInt(this._colIndexes[i2]);
        }
        for (i2 = 0; i2 < this._values.length; ++i2) {
            out.writeDouble(this._values[i2]);
        }
        int totalLen = 0;
        for (i = 0; i < numVals; ++i) {
            totalLen += this.len(i);
        }
        out.writeInt(totalLen);
        for (i = 0; i < numVals; ++i) {
            int len = this.len(i);
            int off = this._ptr[i];
            out.writeInt(len);
            for (int j = 0; j < len; ++j) {
                out.writeChar(this._data[off + j]);
            }
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = 13L;
        ret += (long)(4 * this._colIndexes.length);
        ret += (long)(8 * this._values.length);
        ret += 4L;
        for (int i = 0; i < this.getNumValues(); ++i) {
            ret += (long)(4 + 2 * this.len(i));
        }
        return ret;
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, MatrixBlock result, int rl, int ru) throws DMLRuntimeException {
        if (op.aggOp.increOp.fn instanceof KahanPlus || op.aggOp.increOp.fn instanceof KahanPlusSq) {
            KahanFunction kplus;
            KahanFunction kahanFunction = kplus = op.aggOp.increOp.fn instanceof KahanPlus ? KahanPlus.getKahanPlusFnObject() : KahanPlusSq.getKahanPlusSqFnObject();
            if (op.indexFn instanceof ReduceAll) {
                this.computeSum(result, kplus);
            } else if (op.indexFn instanceof ReduceCol) {
                this.computeRowSums(result, kplus, rl, ru);
            } else if (op.indexFn instanceof ReduceRow) {
                this.computeColSums(result, kplus);
            }
        } else if (op.aggOp.increOp.fn instanceof Builtin && (((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX || ((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN)) {
            Builtin builtin = (Builtin)op.aggOp.increOp.fn;
            if (op.indexFn instanceof ReduceAll) {
                this.computeMxx(result, builtin, this._zeros);
            } else if (op.indexFn instanceof ReduceCol) {
                this.computeRowMxx(result, builtin, rl, ru);
            } else if (op.indexFn instanceof ReduceRow) {
                this.computeColMxx(result, builtin, this._zeros);
            }
        }
    }

    protected abstract void computeSum(MatrixBlock var1, KahanFunction var2);

    protected abstract void computeRowSums(MatrixBlock var1, KahanFunction var2, int var3, int var4);

    protected abstract void computeColSums(MatrixBlock var1, KahanFunction var2);

    protected abstract void computeRowMxx(MatrixBlock var1, Builtin var2, int var3, int var4);

    protected abstract boolean[] computeZeroIndicatorVector();

    @Override
    public Iterator<IJV> getIterator(int rl, int ru, boolean inclZeros, boolean rowMajor) {
        if (rowMajor) {
            return new OffsetRowIterator(rl, ru, inclZeros);
        }
        return new OffsetValueIterator(rl, ru, inclZeros);
    }

    public abstract Iterator<Integer> getIterator(int var1);

    public abstract Iterator<Integer> getIterator(int var1, int var2, int var3);

    protected class OffsetRowIterator
    implements Iterator<IJV> {
        private final int _rl;
        private final int _ru;
        private final boolean _inclZeros;
        private final Iterator<Integer>[] _iters;
        private final IJV _ret = new IJV();
        private final HashMap<Integer, Integer> _ixbuff = new HashMap();
        private int _rpos;
        private int _cpos;
        private int _vpos;

        public OffsetRowIterator(int rl, int ru, boolean inclZeros) {
            int k;
            this._rl = rl;
            this._ru = ru;
            this._inclZeros = inclZeros;
            this._iters = new Iterator[ColGroupOffset.this.getNumValues()];
            for (k = 0; k < ColGroupOffset.this.getNumValues(); ++k) {
                this._iters[k] = ColGroupOffset.this.getIterator(k, this._rl, this._ru);
            }
            for (k = 0; k < ColGroupOffset.this.getNumValues(); ++k) {
                this._ixbuff.put(this._iters[k].hasNext() ? this._iters[k].next() : Integer.valueOf(this._ru + k), k);
            }
            this._rpos = rl - 1;
            this._cpos = ColGroupOffset.this.getNumCols() - 1;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public IJV next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more offset entries.");
            }
            this._ret.set(this._rpos, ColGroupOffset.this._colIndexes[this._cpos], this._vpos < 0 ? 0.0 : ColGroupOffset.this.getValue(this._vpos, this._cpos));
            this.getNextValue();
            return this._ret;
        }

        private void getNextValue() {
            do {
                if (this._cpos + 1 >= ColGroupOffset.this.getNumCols()) {
                    ++this._rpos;
                    this._cpos = -1;
                    this._vpos = -1;
                    Integer ktmp = this._ixbuff.remove(this._rpos);
                    if (ktmp != null) {
                        this._ixbuff.put(this._iters[ktmp].hasNext() ? this._iters[ktmp].next() : Integer.valueOf(this._ru + ktmp), ktmp);
                        this._vpos = ktmp;
                    }
                }
                if (this._rpos >= this._ru) {
                    return;
                }
                ++this._cpos;
            } while (!this._inclZeros && (this._vpos < 0 || ColGroupOffset.this.getValue(this._vpos, this._cpos) == 0.0));
        }
    }

    protected class ZeroValueIterator
    implements Iterator<Integer> {
        private final boolean[] _zeros;
        private final int _ru;
        private int _rpos;

        public ZeroValueIterator(int rl, int ru) {
            this._zeros = ColGroupOffset.this.computeZeroIndicatorVector();
            this._ru = ru;
            this._rpos = rl - 1;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public Integer next() {
            int ret = this._rpos;
            this.getNextValue();
            return ret;
        }

        private void getNextValue() {
            do {
                ++this._rpos;
            } while (this._rpos < this._ru && !this._zeros[this._rpos]);
        }
    }

    protected class OffsetValueIterator
    implements Iterator<IJV> {
        private final int _rl;
        private final int _ru;
        private final boolean _inclZeros;
        private final IJV _buff = new IJV();
        private Iterator<Integer> _viter = null;
        private int _vpos = -1;
        private int _rpos = -1;
        private int _cpos = -1;

        public OffsetValueIterator(int rl, int ru, boolean inclZeros) {
            this._rl = rl;
            this._ru = ru;
            this._inclZeros = inclZeros;
            this._vpos = -1;
            this._rpos = -1;
            this._cpos = 0;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public IJV next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more offset entries.");
            }
            this._buff.set(this._rpos, ColGroupOffset.this._colIndexes[this._cpos], this._vpos >= ColGroupOffset.this.getNumValues() ? 0.0 : ColGroupOffset.this._values[this._vpos * ColGroupOffset.this.getNumCols() + this._cpos]);
            this.getNextValue();
            return this._buff;
        }

        private void getNextValue() {
            if (this._viter != null && this._viter instanceof ZeroValueIterator && !this._viter.hasNext()) {
                this._rpos = this._ru;
                return;
            }
            if (!(this._rpos >= 0 && this._cpos + 1 < ColGroupOffset.this.getNumCols() || this._viter != null && this._viter.hasNext())) {
                do {
                    ++this._vpos;
                    if (this._vpos < ColGroupOffset.this.getNumValues()) {
                        this._viter = ColGroupOffset.this.getIterator(this._vpos, this._rl, this._ru);
                        continue;
                    }
                    if (this._inclZeros && ColGroupOffset.this._zeros) {
                        this._viter = new ZeroValueIterator(this._rl, this._ru);
                        continue;
                    }
                    this._rpos = this._ru;
                    return;
                } while (!this._viter.hasNext());
                this._rpos = -1;
            }
            if (this._rpos < 0 || this._cpos + 1 >= ColGroupOffset.this.getNumCols()) {
                this._rpos = this._viter.next();
                this._cpos = 0;
            } else {
                ++this._cpos;
            }
        }
    }
}

