/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLBreakpointManager;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.VariableSet;

public class MultiAssignmentStatement
extends Statement {
    private ArrayList<DataIdentifier> _targetList;
    private Expression _source;

    @Override
    public Statement rewriteStatement(String prefix) throws LanguageException {
        ArrayList<DataIdentifier> newTargetList = new ArrayList<DataIdentifier>();
        for (DataIdentifier target : this._targetList) {
            DataIdentifier newTarget = (DataIdentifier)target.rewriteExpression(prefix);
            newTargetList.add(newTarget);
        }
        Expression newSource = this._source.rewriteExpression(prefix);
        MultiAssignmentStatement retVal = new MultiAssignmentStatement(newTargetList, newSource);
        retVal.setParseInfo(this);
        return retVal;
    }

    public MultiAssignmentStatement(ArrayList<DataIdentifier> tList, Expression s) {
        this._targetList = tList;
        this._source = s;
    }

    public ArrayList<DataIdentifier> getTargetList() {
        return this._targetList;
    }

    public Expression getSource() {
        return this._source;
    }

    @Override
    public boolean controlStatement() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            DMLBreakpointManager.insertBreakpoint(this._source.getBeginLine());
        }
        return true;
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        return lo;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._source.variablesRead());
        for (int i = 0; i < this._targetList.size(); ++i) {
            if (!(this._targetList.get(i) instanceof IndexedIdentifier)) continue;
            IndexedIdentifier target = (IndexedIdentifier)this._targetList.get(i);
            result.addVariables(target.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (DataIdentifier target : this._targetList) {
            result.addVariable(target.getName(), target);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this._targetList.size(); ++i) {
            sb.append(this._targetList.get(i).toString());
            if (i >= this._targetList.size() - 1) continue;
            sb.append(",");
        }
        sb.append("] = ");
        sb.append(this._source.toString());
        sb.append(";");
        return sb.toString();
    }

    public void setSource(FunctionCallIdentifier s) {
        this._source = s;
    }
}

